#include "mbed.h"
#include "PinDetect.h"

//Init leds using PwmOut
PwmOut red(p26);
PwmOut green(p25);
PwmOut blue(p24);
//Init pushbuttons using PinDetect
PinDetect pb1(p21);
PinDetect pb2(p22);
//Init dip switches using DigitalIn
DigitalIn dip1(p15);
DigitalIn dip2(p16);
DigitalIn dip3(p17);


//Increment or decrement the led depending on which button was pressed
void pb1_pressed(void) {
    if (dip1 == 1 && red < 1) { red = red + .1; }
    if (dip2 == 1 && green < 1) { green = green + .1; }
    if (dip3 == 1 && blue < 1) { blue = blue + .1; }
}
void pb2_pressed(void) {
    if (dip1 == 1 && red > 0) { red = red - .1; }
    if (dip2 == 1 && green > 0) { green = green - .1; }
    if (dip3 == 1 && blue > 0) { blue = blue - .1; }
}

int main() {
    //Set buttons internal pullup
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    //set for the pressed functions to be called when the button is pressed
    pb1.attach_asserted(&pb1_pressed);
    pb2.attach_asserted(&pb2_pressed);
    //Default the sample freq
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    //Set switches internal pullup
    dip1.mode(PullUp);
    dip2.mode(PullUp);
    dip3.mode(PullUp);

    //Loop forever
    while(1) {
        if (dip1 == 0) { red = 0; }
        if (dip2 == 0) { green = 0; }
        if (dip3 == 0) { blue = 0; }    
    }
}

