#include "mbed.h"
/*
Prints to terminal start and end time of each cycle. Writes times to txt file on mbed. 
Mbed acts as disconnected to computer when writing to local directory. 
Mbed will be return to device manager after test has completed. 
To regain access to mbed while test is running press "e" to terminate program. 

Navigate to mbed after test has completed. 
Test results in file "test"
File will be overwritten with each test. Rename file in code if want to keep multiple files
*/

Serial pc(USBTX, USBRX); // tx, rx


DigitalIn sensor1(p5);
DigitalIn sensor2(p6);
LocalFileSystem local("local");

Timer t;
int change = 0;
int count = 1;
const int endcount = 10;


int main()
{
    pc.printf("Break sensor to start timer \n \r");
    FILE *fp = fopen("/local/test.txt", "w");


    while(1) {
        if (change == 0 && sensor1) {
            change = 1;
            t.reset();
            t.start();
            pc.printf("Start: Count= %d \n \r", count);
        }


        if (change && sensor2) {
            t.stop();
            pc.printf("End. Time taken was %f seconds \n \r", t.read());
            change = 0;
            fprintf(fp, "%f \n", t.read());
            count++;
        }

        if (count>endcount) {
            pc.printf("Done");
            fclose(fp);
            return 0;
        }

        if (pc.readable()) {
            char c = pc.getc();
            if(c == 'e') {
                pc.printf("Program terminated");
                return 0;
            }
        }



    }
}
