#include "mbed.h"


Serial lcd(p13,p14);

DigitalOut pneumatics1(p25);
DigitalOut pneumatics2(p26);
DigitalOut box1(p23);
DigitalOut box2(p22);
DigitalOut box3(p21);
DigitalIn  pause(p6);

void clearLCD()
{
    lcd.printf("%c%c",0xFE,0x01);
}
void setLCDpos(int xpos, int ypos)
{
    int pos = 0x80;
    switch (xpos) {
        case 1:
            pos +=0;
            break;
        case 2:
            pos +=64;
            break;
        case 3:
            pos +=20;
            break;
        case 4:
            pos +=84;
            break;
    }
    pos += (ypos-1);
    lcd.printf("%c%c",0xFE,pos);
}
void setBrightness(int lev)
{
    lcd.printf("%c%c",0xFE,lev+127);

    wait(.1);
}
//End LCD Setup


int count = 1;
int cycles = 2500;
int check = 0;



int main()
{
    clearLCD();
    setLCDpos(1,1);
    lcd.printf("Here we go!");
    while(count< cycles) {

        if (pause) {
            check = 1;
            //Trigger solenoid
            box1 = 1;
            box2 = 0;
            box3 = 0;
            wait(.08);

            box1 = 0;
            box2 = 1;
            wait(.08);

            box2 = 0;
            box3 = 1;
            wait(.08);


            box3 = 0;


            //Wait until box completely opens then trigger pneumatics
            wait(.7);
            pneumatics1 = 1;
            pneumatics2 = 0;

            //Wait until cylinder has finished travel
            wait(.8);
            pneumatics1 = 0;
            pneumatics2 = 1;
            wait(.5);
            pneumatics2 =0;

            //Wait to full retract then repeat
            wait(5);
          
            count++;
            setLCDpos(2,1);
            lcd.printf("%d",count);

        }
        else {
            check = 0;
        }

        setLCDpos(3,1);
        lcd.printf("%d", check); 
    } 
}
