#ifndef _ROS_stm32_manche_a_air_Manche_a_air_h
#define _ROS_stm32_manche_a_air_Manche_a_air_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include <Servo.h>
#include "../actuators.h"
#include "ros/msg.h"


#define MAA_CLOSING_TIMEOUT 1
#define MAA_OPENING_TIMEOUT 1
#define MAA_PAUSE_TIMEOUT 1



namespace stm32_actuators_node
{

  class Manche_a_air_msg : public ros::Msg
  {
    public:
        typedef uint8_t _index_manche_a_air_type;
        _index_manche_a_air_type index_manche_a_air;
        typedef uint8_t _manche_a_air_order_type;
        _manche_a_air_order_type manche_a_air_order;

        Manche_a_air_msg():
            index_manche_a_air(0),
            manche_a_air_order(0)
        {
        }
    
        virtual int serialize(unsigned char *outbuffer) const
        {
            int offset = 0;
            *(outbuffer + offset + 0) = (this->index_manche_a_air >> (8 * 0)) & 0xFF;
            offset += sizeof(this->index_manche_a_air);
            *(outbuffer + offset + 0) = (this->manche_a_air_order >> (8 * 0)) & 0xFF;
            offset += sizeof(this->manche_a_air_order);
            return offset;
        }
    
        virtual int deserialize(unsigned char *inbuffer)
        {
            int offset = 0;
            this->index_manche_a_air =  ((uint8_t) (*(inbuffer + offset)));
            offset += sizeof(this->index_manche_a_air);
            this->manche_a_air_order =  ((uint8_t) (*(inbuffer + offset)));
            offset += sizeof(this->manche_a_air_order);
            return offset;
        }
    
        const char * getType(){ return "stm32_actuators/Manche_a_air_msg"; };
        const char * getMD5(){ return "33a9b4e076016e58fe35593be08a2827"; };

  };

}


void maa_trait_msg(const stm32_actuators_node::Manche_a_air_msg& manche_a_air_msg);



class Manche_a_air
{
    public:
    
        typedef enum
        {closed, opening, opened, closing}
        state_manche_a_air_t;
        
        typedef enum
        {close, open}
        manche_a_air_order_t;
    
        Manche_a_air(PinName pin_servo, float servo_open, float servo_close);
        
        void update_order(int order);
        void automate(void);
        
        manche_a_air_order_t _order;
        state_manche_a_air_t _state;
        Servo* _servo;
        
        float _servo_open;
        float _servo_close;
        
        float _time;
        
        int _flag_auto_open;
        int _flag_auto_close;
        float _timeout_auto_open;
        float _timeout_auto_close;
                
        void set_auto_open(int flag, float timeout);
        void set_auto_close(int flag, float timeout);

};
#endif
