#include "mbed.h"
#include "HDC1000.h"
#include "SevenSegLed.h"

// I2C Communication
HDC1000      hmtp(D14,D15);    // HDC1000 SDA, SCL (Akizuki module)

//                      common type (0:anode common 1:cathode common)
//                      |
//                      |  display mode (0:smooth 1:hard)
//                      |  |
//                      |  |  segA segB segC segD segE segF segG segP com1 com2 com3 com4 (com5,com6,com7,com8 = NC)                          
//                      |  |  |    |    |    |    |    |    |    |    |    |    |    |
SevenSegLed sevenSegLed(1, 1, D13, D12, D11, D10, D5,  D4,  D3,  D2,  D9,  D8,  D7,  D6);
DigitalOut relay(D1);

// display buffer
//                   com1
//                   |  com2
//                   |  |  com3
//                   |  |  |  com4
//                   |  |  |  |
uint8_t D_7seg[4] = {0, 0, 0, 0};   // 0x0 to 0x9 = "0" to "9" ,0xA to 0xF = "A" to "F", 0x10 = extinction
uint8_t D_dot[4]  = {0, 1, 0, 0};   // 0:extinction  1: light

int hundred, ten, one;
float SP, Hys;

//main
int main() {
    
   relay = 0;

   while(1) {
       hmtp.get();    // Triger conversion
       
       //temperature
       hundred = hmtp.temperature() * 10;  
       hundred = hundred / 100;
       D_7seg[0] = hundred;
       
       ten = hmtp.temperature() * 10;
       ten = ten - (hundred * 100);
       ten = ten / 10;
       D_7seg[1] = ten;
       
       one = hmtp.temperature() * 10;
       one = one - (hundred * 100) - (ten * 10);
       D_7seg[2] = one;
       
       D_7seg[3] = 0xC;

       D_dot[1] = 1;
       D_dot[0] = 0;
       D_dot[2] = 0;

       // set dynamic output data
       sevenSegLed.SevenSegLed_main(D_7seg, D_dot);   

       wait(3.0);
       
       //humidity
       hundred = hmtp.humidity() * 10;  
       hundred = hundred / 100;
       D_7seg[0] = hundred;
       
       ten = hmtp.humidity() * 10;
       ten = ten - (hundred * 100);
       ten = ten / 10;
       D_7seg[1] = ten;
       
       one = hmtp.humidity() * 10;
       one = one - (hundred * 100) - (ten * 10);
       D_7seg[2] = one;
       
       D_7seg[3] = 0x10;

       D_dot[1] = 1;
       D_dot[0] = 0;
       D_dot[2] = 0;

       // set dynamic output data
       sevenSegLed.SevenSegLed_main(D_7seg, D_dot);         
        
       SP = 48.0;
       Hys = 4.0;
       if( hmtp.humidity() <= SP )
        relay = 1;
       else if( hmtp.humidity() >= (SP + Hys) )
        relay = 0;

       wait(3.0);

   }
}
