#include "ShiftReg.h"
#include "mbed.h"

template <class T_bit>
ShiftReg<T_bit>::ShiftReg(PinName dataPin, PinName stbPin, 
                   PinName clkPin, PinName clrPin)
: 
    DATA(dataPin),
    STB(stbPin),
    CLK(clkPin),
    CLR(clrPin)
{
    DATA = 1;
    STB  = 1;
    CLK  = 1;
    CLR  = 1;
}

template <class T_bit>
void ShiftReg<T_bit>::send_data(T_bit data, uint8_t size) {
    shiftOut(data, size);
    wait_us(1);
#ifdef HC595
    STB = 0;
    wait_us(1);
    STB = 1;
#elif NJU3711
    STB = 1;
    wait_us(1);
    STB = 0;
#else
    printf("not support\n");
#endif
    wait_us(1);
}

template <class T_bit>
void ShiftReg<T_bit>::shiftOut(T_bit data, uint8_t size) {
    for(int i = 0; i < size; i++) {
        DATA = (data & (1 << i));
        CLK = 0;
        CLK = 1;
    }
}
template class ShiftReg<uint8_t>;
template class ShiftReg<uint16_t>;
template class ShiftReg<uint32_t>;