#ifndef MBED_SHIFTREG_H
#define MBED_SHIFTREG_H
#define HC595
//#define NJU3711
#include "mbed.h"

template <class T_bit>
class ShiftReg {
public:
    ShiftReg(PinName dataPin, PinName stbPin, PinName clkPin, PinName clrPin);
    void send_data(T_bit data, uint8_t size);
    typedef ShiftReg<uint8_t> ShiftReg8;
    typedef ShiftReg<uint16_t> ShiftReg16;
    typedef ShiftReg<uint32_t> ShiftReg32;

  
private:  
    DigitalOut DATA;
    DigitalOut STB;
    DigitalOut CLK;
    DigitalOut CLR;
    void shiftOut(T_bit data, uint8_t size);
};
 
#endif