/* main.cpp */
/* v1.1
 * Copyright (C) 2015 nimbelink.com, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"
#include "LPS331.h"
#include "LIS3DH.h"
#include "LM75B.h"
#include "hts221.h"

/* --CHANGE THIS FOR YOUR SETUP" -- */
#define DeviceID "A1000032BD4DAF"  //Freeboard DweetIO unique ID

DigitalOut myled(LED1);
DigitalOut skywire_en(PA_6);
DigitalOut skywire_rts(PA_7);

Serial skywire(PA_9,PA_10);
Serial debug_pc(USBTX, USBRX);

I2C i2c(PB_9,PB_8);
char msg[3];

LPS331 pressure(i2c);
LM75B LM75_temp(PB_9,PB_8);
LIS3DH accel(i2c, LIS3DH_V_CHIP_ADDR, LIS3DH_DR_NR_LP_100HZ, LIS3DH_FS_2G);
HTS221 humidity(PB_9, PB_8);


char str[255];

float latitude;
float longitude;
int number;

volatile int rx_in=0;
volatile int rx_out=0;
const int buffer_size = 255;
char rx_buffer[buffer_size+1];

char rx_line[buffer_size];

void Skywire_Rx_interrupt() {
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((skywire.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = skywire.getc();
        rx_in = (rx_in + 1) % buffer_size;
    }
    return;
}

void read_line() {
    int i;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    __disable_irq();
// Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\n')) {
// Wait if buffer empty
        if (rx_in == rx_out) {
// End Critical Section - need to allow rx interrupt to get new characters for buffer
            __enable_irq();
            while (rx_in == rx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            __disable_irq();
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
// End Critical Section
    __enable_irq();
    rx_line[i-1] = 0;
    return;
}
int WaitForResponse(char* response, int num) {
    do {
        read_line();
        debug_pc.printf("Waiting for: %s, Recieved: %s\r\n", response, rx_line);
    } while (strncmp(rx_line, response, num));
    return 0;
}
int main()
{
    float axis[3];
    float press;
    float temp;
    float humi;
    float dummy_temp;


    debug_pc.baud(115200);
    skywire.baud(115200);
    debug_pc.printf("SystemCoreClock = %d Hz\n", SystemCoreClock);
    
    skywire.attach(&Skywire_Rx_interrupt, Serial::RxIrq);
    skywire_rts=0;
    myled=0;
    debug_pc.printf("Starting Demo...\r\n");
    debug_pc.printf("Waiting for Skywire to Boot...\r\n");
    //Enable Skywire
    skywire_en=0;
    wait(2);
    skywire_en=1;
    wait(2);
    skywire_en=0;

    myled=1;
    wait(5);

    LM75_temp.open();
    
    //Turn off echo
    skywire.printf("ATE0\r\n");
    WaitForResponse("OK", 2);
    
    debug_pc.printf("Connecting to Network...\r\n");
    // get IP address
    skywire.printf("AT#SGACT=1,1\r\n");
    WaitForResponse("#SGACT", 6);
    WaitForResponse("OK", 2);
    
    // connect to dweet.io
    skywire.printf("AT#HTTPCFG=1,\"dweet.io\",80,0\r\n");
    WaitForResponse("OK", 2);

    
    //get location approximation from cell tower information
    skywire.printf("AT#AGPSSND\r\n");
    WaitForResponse("#AGPSRING:", 10);

    //debug_pc.printf("Skywire says: %s\r\n", rx_line);
    sscanf(rx_line, "%s %d,%f,%f,", str, &number, &latitude, &longitude);
    debug_pc.printf("Location: Latt:%f, Long:%f\r\n", latitude, longitude);
    
    wait(3);
    
    while(1) {
        temp = (float)LM75_temp;
        debug_pc.printf("Temp = %.3f\r\n", temp);
        press=(float)pressure.value() / 4096;
        debug_pc.printf("Pressure = %.3f\r\n", press);
        humidity.ReadTempHumi(&dummy_temp, &humi);
        debug_pc.printf("Humidity = %.3f\r\n", humi);
        accel.read_data(axis);
        debug_pc.printf("Accel = %.3f, %.3f, %.3f\r\n", axis[0], axis[1], axis[2]);
        //wait(10);
        
        //Report Sensor Data to dweet.io
        skywire.printf("AT#HTTPQRY=1,0,\"/dweet/for/%s?temp=%.3f&press=%.3f&humi=%.3f&X=%.3f&Y=%.3f&Z=%.3f&Latitude=%f&Longitude=%f\"\r\n", DeviceID, temp, press, humi, axis[0], axis[1], axis[2], latitude, longitude);
        WaitForResponse("#HTTPRING", 9);
        skywire.printf("AT#HTTPRCV=1\r\n");
        WaitForResponse("OK", 2);
        wait(5);
    }

}
