#include "mbed.h"
#include "SHTx/sht15.hpp"
#include "SCP1000.h"
#include "uLCD_4DGL.h"
 
uLCD_4DGL uLCD(p28,p27,p29); // serial tx, serial rx, reset pin;
SCP1000 scp1000(p5,p6,p7,p8);
SHTx::SHT15 sensor(p9, p10);
DigitalOut busy(LED1);
DigitalIn mode(p14);


// Declare pins for color sensor
AnalogIn red_in(p15);
AnalogIn green_in(p16);
AnalogIn blue_in(p17);
 
BusOut red_gain(p26, p25);
BusOut green_gain(p24, p23);  
BusOut blue_gain(p22, p21);  



float comfort_calc(float val, int min, int max){
    float delta;
    
    if (val < min)
        delta = val-min;
    else if (val > max)
        delta = val - max;
    else
        delta = 0;
    
    delta = delta * 10 / (max-min);
        
    return delta;
}

void delta_print(float delta, char* type){
    if (delta == 0)
        uLCD.printf("%s: GOOD   \r\n", type);
    else if (delta < 0)
        uLCD.printf("%s: LOW   \r\n", type);
    else
        uLCD.printf("%s: HIGH   \r\n", type);
}

int main() {
    // Speed things up a bit.
    sensor.setOTPReload(false);
    sensor.setResolution(true);
    
    //Declare internal variables
    float temp, humid, inHg, tempF;
    int press;
    
    int red = 0;
    int green = 0;
    int blue = 0;
       
    int prev_mode = 0;
    
    //declare comfort values 
    float temp_delta = 0;
    float humid_delta = 0;
    float press_delta = 0;
    float color_delta = 0;
    
    float comfort = 0;
    
    // Sets the gain of the color sensor
    red_gain = 3;
    green_gain = 3;
    blue_gain = 3;
    
    sensor.setScale(false); // Sets the sensor temp. setting to Celsius
    
    uLCD.baudrate(600000);
    uLCD.cls();
    while(1) {
        //busy = true;
        sensor.update();
        
        temp = (sensor.getTemperature() + scp1000.readTemperature() )/ 2;   // Averages the 2 available temperature readings
        humid = sensor.getHumidity();
        press = scp1000.readPressure();
        busy = false;        
        
        tempF = temp * 9.0 / 5.0 + 32.0; // Converts temp from C to F
        
        // Scale the RGB sensor values to usuable values
        red = red_in * 1000;
        green = green_in * 1000;
        blue = blue_in * 1700;
        
        // Convert pressure to mmhg
        inHg = press / 3376.85;
        

        temp_delta = comfort_calc(tempF, 65, 75);
        humid_delta = comfort_calc(humid, 30, 70);
        press_delta = comfort_calc(inHg, 28, 31);
        color_delta = comfort_calc(red+green+blue, 30, 450);
        
        
        
        comfort = abs(temp_delta) + abs(humid_delta) + abs(press_delta)+ abs(color_delta);
        comfort = 100 - comfort;

        // Beggining of printing modes
        uLCD.locate(0,0);
        
                
        if (mode==0){     // Sensor detail mode   
            if (prev_mode != mode)
                uLCD.cls();
                
            // Prints the temperature in celcius            
            uLCD.printf("Temp: %3.2f F\r\n", tempF);
            
            // Prints the relative Humidity
            uLCD.printf("Humdity: %3.2f %%\r\n", humid);
            
            // Prints barometric pressure
            uLCD.printf("Press: %3.2f inHg\r\n\n", inHg);
            if (inHg >=28.9)
                uLCD.printf("High Pressure");
            else 
                uLCD.printf("Low Pressure");
            
            //Print color sensor values
            uLCD.printf("\n\n");
            uLCD.printf("Red: %i\r\n", red);
            uLCD.printf("Green: %i\r\n", green);
            uLCD.printf("Blue: %i\r\n", blue);  
            
            uLCD.printf("\nt:%3.2f h:%3.2f \np:%3.2f l:%3.2f \r\n", temp_delta, humid_delta, press_delta, color_delta);
            
            prev_mode = 0;
        }
        else { // Normal mode
            if (prev_mode != mode)
                uLCD.cls();

        
            delta_print(temp_delta, "Temp");
            delta_print(humid_delta, "Humid");
            delta_print(press_delta, "Press");
            delta_print(color_delta, "Light");
            
            if (comfort >90)
                uLCD.printf("\n\nComfortable   \r\n");
            else
                uLCD.printf("\n\nUncomfortable\r\n");
            
            uLCD.printf("Rating %3.0f/100\r\n", comfort);  
            prev_mode = 1;
        }
        wait(.5);
    }
}


