#include "mbed.h"
#include "uLCD_4DGL.h"
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
AnalogIn signal(p20);
AnalogIn rawSignal(p19);
InterruptIn cutoffSwitch(p8);
Serial  dev(p13,p14);
uLCD_4DGL uLCD(p28,p27,p11);

void interruptRoutine() {
    dev.printf("%f",9999);
    myled = 1;
    myled2 = 1;
    myled3 = 1;
    myled4 = 1;
    while(1){}
}

int main() {
    float EMG[130];
    cutoffSwitch.rise(&interruptRoutine);
    
    float EMG_raw[130];
    int index = 5;
    EMG[0] = 60;
    EMG[1] = 60;
    EMG[2] = 60;
    EMG[3] = 60;
    EMG[4] = 60;
    uLCD.baudrate(600000);
    dev.baud(9600);
    uLCD.printf("Waiting for \nbluetooth \nhandshake signal!");
    uLCD.filled_rectangle(35, 55, 45, 65, RED);
    uLCD.filled_rectangle(50, 55, 60, 65, RED);
    uLCD.filled_rectangle(65, 55, 75, 65, RED);
    uLCD.filled_rectangle(80, 55, 90, 65, RED);
    int counter = 0;
    while(!dev.readable()){
            if(counter/100 == 0)
            {
                uLCD.filled_rectangle(35, 55, 45, 65, BLACK);
                uLCD.filled_rectangle(50, 55, 60, 65, RED);
                uLCD.filled_rectangle(65, 55, 75, 65, RED);
                uLCD.filled_rectangle(80, 55, 90, 65, RED);
            }
            if(counter/100 == 1)
            {
                uLCD.filled_rectangle(50, 55, 60, 65, BLACK);
                uLCD.filled_rectangle(35, 55, 45, 65, RED);
                uLCD.filled_rectangle(65, 55, 75, 65, RED);
                uLCD.filled_rectangle(80, 55, 90, 65, RED);
            }
            if(counter/100 == 2)
            {
                uLCD.filled_rectangle(65, 55, 75, 65, BLACK);
                uLCD.filled_rectangle(35, 55, 45, 65, RED);
                uLCD.filled_rectangle(50, 55, 60, 65, RED);
                uLCD.filled_rectangle(80, 55, 90, 65, RED);
            }
            if(counter/100 == 3)
            {
                uLCD.filled_rectangle(80, 55, 90, 65, BLACK);
                uLCD.filled_rectangle(35, 55, 45, 65, RED);
                uLCD.filled_rectangle(50, 55, 60, 65, RED);
                uLCD.filled_rectangle(65, 55, 75, 65, RED);

            }
            if(counter >= 400)
            {
                counter = 0;
            }
            counter++;
        }
    int choice = dev.getc();
    uLCD.cls();
    uLCD.line(5, 0, 5, 62, WHITE);
    uLCD.line(5, 65, 5, 127, WHITE);
    uLCD.line(0, 60, 130, 60, WHITE);
    uLCD.line(0, 125, 130, 125, WHITE);
    int offset = 0;
    while(1) {
    
        
        myled = !myled;
        float voltage_rectified = signal;
        float voltage_raw = rawSignal;
        //EMG[index] = 60 - voltage_rectified * 60;
        EMG_raw[index] = 150 - voltage_raw * 240;
        EMG[index] = 60 - voltage_rectified * 55;
        //printf("Voltage: %3f \r\n",EMG_raw[index]);
        
        while(!dev.writeable()){}
        if(choice == '1')
        {
            dev.printf("%.2f",voltage_raw);
        }   
        if(choice == '2')
        {
            dev.printf("%.2f",voltage_rectified);
        } 
        
        int ref = EMG[index-1];
        
        if((ref > EMG[index])&&((index-1) != 4))
        {
            if(index < 124)
            {
                uLCD.filled_rectangle(index, 0 +offset, index+5, 55 + offset, BLACK);
                
            }
            while(ref > EMG[index])
            {
                uLCD.pixel(index,ref+offset,RED);
                ref = ref-3;
            }
        }
        else if((ref < EMG[index])&&((index-1) != 4))
        {
            if(index < 124)
            {
                uLCD.filled_rectangle(index, 0 +offset, index + 5, 59 + offset, BLACK);
                
            }
            uLCD.filled_rectangle(index, 0 +offset, index, 59 + offset, BLACK);
            while(ref < EMG[index])
            {
                uLCD.pixel(index,ref+offset,RED);
                ref = ref+3;
            }
        }
        uLCD.pixel(index,EMG[index] + offset,RED);
        //ADDED
        ref = EMG_raw[index-1];
        if((ref > EMG_raw[index])&&((index-1) != 4))
        {
            if(index < 124)
            {
                uLCD.filled_rectangle(index, 0 +61, index+5, 59 + 65, BLACK);
                
            }
            while(ref > EMG_raw[index])
            {
                uLCD.pixel(index,ref+65,GREEN);
                ref = ref-3;
            }
        }
        else if((ref < EMG_raw[index])&&((index-1) != 4))
        {
            if(index < 124)
            {
                uLCD.filled_rectangle(index, 0 +65, index + 5, 59 + 65, BLACK);
                
            }
            uLCD.filled_rectangle(index, 0 +65, index, 59 + 65, BLACK);
            while(ref < EMG_raw[index])
            {
                uLCD.pixel(index,ref+65,GREEN);
                ref = ref+3;
            }
        }
        uLCD.pixel(index,EMG_raw[index] + 65,GREEN);
        //
        index++;
        
        
        if(index == 130)
        {
            index = 5;
            
        }
        wait(.1);
    }
}
