#include "mbed.h"
#include "JPEGCamera.h"
#include "SDFileSystem.h"

DigitalOut myled1(LED1); //show successful picture was taken 
DigitalOut myled2(LED2); //show end of sequence
DigitalOut myled3(LED3); //show picture take failed
DigitalOut myled4(LED4); //show camera is not ready

SDFileSystem sd(p5,p6,p7,p8,"sd");
AnalogIn ain(p15);

LocalFileSystem local("local");
#define FILENAME "/sd/pict%03d.jpg"

int main() {
    
    printf("%s\n", __FILE__); //sourcefilename printout
    printf("start!!\n");
    
    JPEGCamera camera(p9, p10); // TX, RX
    LocalFileSystem local("local"); //save images on mbed
    Timer timer;
    timer.start();
    camera.setPictureSize(JPEGCamera::SIZE320x240);
    
     FILE *fp;
    if ((fp==fopen(FILENAME,"wb")) == NULL) ;
    
    
    for (int i = 0; i < 2; i++) {
        
        if (camera.isReady()) {
            char filename[32];
            sprintf(filename, "/sd/pict%03d.jpg", i);
            printf("Picture: %s ", filename);
            if (camera.takePicture(filename)) {
                while (camera.isProcessing()) {
                    camera.processPicture();
                }
                myled1 = 1; //show successful picture was taken 
                wait(2.0);
                myled1 = 0;
            } else {
                printf("take picture picture\n");
                myled3 = 1; //show picture take failed
                wait(2.0);
                myled3 = 0;
            }
        } else {
            printf("show camera is not ready\n");
            myled4 = 1; //show camera is not ready
            wait(2.0);
            myled4 = 0;
        }
    }
    myled2 = 1; //show end of sequence
    wait(2.0);
    myled2 = 0;
    printf("time = %f\n", timer.read());
    
   fclose(fp);
    exit(1);
}