#include "mbed.h"
#include "TextLCD.h"
  
TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

 
Serial pc(USBTX, USBRX); // tx, rx
Serial device(p9, p10);  // tx, rx

char buf[] = "hello";
char reset[] = {0x56, 0x00, 0x26, 0x00};
int i_buf = 0;
int i_reset = 0;

void pc_rx () {
    char c = pc.getc();
    device.putc(c);
    lcd.putc(c);
}
 
void dev_rx () {
    char c = device.getc();
    pc.putc(c);
    lcd.putc(c);
}
 
void pc_tx () {
    pc.putc(buf[i_buf]);
    i_buf++;
    if (i_buf >= sizeof buf) {
       pc.attach(NULL, Serial::TxIrq);
    }
}
 
void device_tx () {
    device.putc(reset[i_reset]);
    i_reset++;
    lcd.putc('-');
    if (i_reset >= sizeof(reset)) {
       device.attach(NULL, Serial::TxIrq);
    }
}

int main() {
    device.baud(38400);
    //pc.baud(9600);

    pc.attach(pc_rx, Serial::RxIrq);
    //pc.attach(pc_tx, Serial::TxIrq);

    device.attach(dev_rx, Serial::RxIrq);
    device.attach(device_tx, Serial::TxIrq);
    
    //lcd.putc('m');
    //pc.putc('m');
    device.putc('!');
    pc.readable();
    device.readable();
    wait(2.0);
    lcd.printf("OK!\n");
    while(1);
}
