#ifndef FAST_JPEG_CAMERA_H
#define FAST_JPEG_CAMERA_H

#include "JPEGCamera/JPEGCamera.h"

#define FILENAME "/sd/pic%05d.jpg"

#define min(x, y) ((x) < (y)) ? (x) : (y)

class FastJpegCamera : public JPEGCamera {
    public:
        DigitalOut myled1; //show successful picture was taken 
        int baudrate;
        Serial pc;
        Serial& xbee;

        FastJpegCamera(PinName tx, PinName rx, Serial& xbee) : JPEGCamera(tx,rx), baudrate(38400), pc(USBTX, USBRX), myled1(LED1), xbee(xbee){
            this->baud115200();
        };
        
        void baud115200(){
            char buf[7] = {0x56, 0x00, 0x24, 0x03, 0x01, 0x0d, 0xa6};
            //char buf[5] = {0x56, 0x00, 0x34, 0x0d, 0xa6};
            //int ret = sendReceive(buf, sizeof buf, 5);
            for (int i = 0; i < sizeof buf; i++) putc(buf[i]);
            wait(0.5);
            this->baudrate = 115200;
            this->baud(this->baudrate);
            wait(4);
            //this->reset();
            receive(buf, 5, 500);
            pc.printf("%02x %02x %02x %02x %02x", buf[0], buf[1], buf[2], buf[3], buf[4]);
        };

        void baud57600(){
            char buf[7] = {0x56, 0x00, 0x24, 0x03, 0x01, 0x1c, 0x4c};
            int ret = sendReceive(buf, sizeof buf, 5);
            wait(0.5);
            this->reset();
            this->baudrate = 57600;
            this->baud(this->baudrate);
        };


        void baud38400(){
            char buf[7] = {0x56, 0x00, 0x24, 0x03, 0x01, 0x2a, 0xf2};
            //int ret = sendReceive(buf, sizeof buf, 5);
            for (int i = 0; i < sizeof buf; i++) putc(buf[i]);
            wait(0.5);
            //this->reset();
            this->baudrate = 38400;
            this->baud(this->baudrate);
            wait(4);
            //this->reset();
            receive(buf, 5, 500);
            pc.printf("%02x %02x %02x %02x %02x", buf[0], buf[1], buf[2], buf[3], buf[4]);
        };
        
        bool processPicture() {
            if (state == PROCESSING) {
                if (address < imageSize) {
                    char data[1024];
                    int size = readData(data, min(sizeof(data), imageSize - address), address);
                    int ret = fwrite(data, size, 1, fp);
                    if (ret > 0)
                        address += size;
                    if (ret == 0 || address >= imageSize) {
                        stopPictures();
                        fclose(fp);
                        wait(0.1); // ????
                        state = ret > 0 ? READY : ERROR;
                    }//if
                    //for(int i=0; i<sizeof data; ++i){
                    //    xbee.putc(data[i]);
                    //    //pc.printf("%02x ",  data[i]);
                    //}//for
                }//if
            }//if
            return state == PROCESSING || state == READY;
        }//processPicture

        void shoot(int i){
        
            if (!this->isReady()) {
                pc.printf("show camera is not ready\n");
                //myled4 = 1; //show camera is not ready
                //wait(2.0);
                //myled4 = 0;
                return;
            }//if
        
            char filename[32];
            sprintf(filename, FILENAME, i);
            printf("Picture: %s ", filename);
            myled1 = 1;
            if (this->takePicture(filename)) {
                while (this->isProcessing()) {
                    this->processPicture();
                }//while
                //myled1 = 1; //show successful picture was taken 
                //wait(2.0);
                //myled1 = 0;
            } else {
                pc.printf("shot %s\n", filename);
                //myled3 = 1; //show picture take failed
                //wait(2.0);
                //myled3 = 0;
            }//if
            this->stopPictures();
            myled1 = 0;
        };//shoot


};//FastJpegCamera

#endif
