#include "mbed.h"
#include "C12832.h" 

// LCD display
C12832 lcd(p5, p7, p6, p8, p11);

//Joystick
//DigitalIn joyU(p13); // joystick 'DOWN' resets the stopwatch
//DigitalIn joyC(p14); // joystick 'PUSH' starts and stops it


InterruptIn joyD(p12); // joystick 'DOWN' resets the stopwatch
InterruptIn joyC(p14); // joystick 'PUSH' starts and stops it
InterruptIn joyU(p13); // joystick 'UP' toggle the display

void joyC_isr();
void joyD_isr();
void joyU_isr();
bool joyUflag = 0;
bool joyCflag = 0;
bool joyDflag = 0;

float saved_lap_times [8] = {0.0};
int i= 0;

int main() 
{
    float t = 0.0; // the timer a floating point counter
    bool run = 1; // the state of the stopwatch run stopped
    
    //At startup just print a few things on the lcd and then enter a loop until the user does something
    lcd.cls(); //clear screen
    lcd.locate(1,20);
    lcd.printf("ready push joystick to start");//ready to go
    lcd.locate(10,10);
    lcd.printf("Stopwatch time %4.1f",t);//display time on the stopwatch
    
    joyC.rise(&joyC_isr);
    joyD.rise(&joyD_isr);
    joyU.rise(&joyU_isr);
    
    while(1) 
    {
        //reset timer if the joystick is pressed 'DOWN'
        
        if (joyDflag)
        {
            t = 0; // clear the timer
            run = !run; // and stop further operation
            lcd.cls(); //clear screen
            lcd.locate(40,20);
            lcd.printf("reset");//tell the user
            lcd.locate(10,10);
            lcd.printf("Stopwatch time %4.1f",t);//display time on the stopwatch
            for(int j=0; j<=8; j++)
            {
                saved_lap_times[j] = 0.0;
            }
            i=0;
        }
        
        /*this is the bit that decides if the stopwatch is running
        i.e. run == 1, if so then increment the timer and print its value
        otherwise just wait*/
        
        //if (joyCflag)
        if(run == 1)
        {
            t =t + 0.1;
            
            if(!joyUflag)
            {
                wait(0.1);
                lcd.cls(); //clear screen
                lcd.locate(10,10);
                lcd.printf("Stopwatch time %4.1f",t);//display time
            }
            else
            {
                wait(0.01);
                lcd.cls(); //clear screen
                lcd.locate(1,1);
                lcd.printf("L1:");//display time
                lcd.locate(13,1);
                lcd.printf("%3.1f",saved_lap_times [0]);
                lcd.locate(42,1);
                lcd.printf("L2:");//display 
                lcd.locate(54,1);
                lcd.printf("%3.1f",saved_lap_times [1]);
                lcd.locate(82,1);
                lcd.printf("L3:");//display time
                lcd.locate(95,1);
                lcd.printf("%3.1f",saved_lap_times [2]);
                lcd.locate(1,11);
                lcd.printf("L4:");//display time
                lcd.locate(13,11);
                lcd.printf("%3.1f",saved_lap_times [3]);
                lcd.locate(42,11);
                lcd.printf("L5:");//display 
                lcd.locate(54,11);
                lcd.printf("%3.1f",saved_lap_times [4]);
                lcd.locate(82,11);
                lcd.printf("L6:");//display time
                lcd.locate(95,11);
                lcd.printf("%3.1f",saved_lap_times [5]);
                lcd.locate(1,22);
                lcd.printf("L7:");//display time
                lcd.locate(13,22);
                lcd.printf("%3.1f",saved_lap_times [6]);
                lcd.locate(42,22);
                lcd.printf("L8:");//display 
                lcd.locate(54,22);
                lcd.printf("%3.1f",saved_lap_times [7]);
                lcd.locate(82,22);
                lcd.printf("L9:");//display time
                lcd.locate(95,22);
                lcd.printf("%3.1f",saved_lap_times [8]);
            }
        }
        
        //use it to save the current time with the push of centre button
        if(joyCflag)
        {
            joyCflag=0;
            
            if(i<=8)
            {
                saved_lap_times[i]=t;
                i++;
            }
        }
        
        //toggle the display
        
        /* this bit toggles the run control between the run / stopped states
         when the joystick is pushed 'IN' */
         
        //if (run == 1)
       // {
            //if (!joyCflag)
            //{ // was running so stop it
                //run = 0;
                //lcd.locate(40,20);
               //lcd.printf("stopped");//timer has stopped
            //}
        //}
    }
}

void joyC_isr() 
{
 joyCflag = !joyCflag;
}

void joyD_isr()
{
    joyDflag = !joyDflag;
    joyCflag = 0;
}

void joyU_isr() 
{
 joyUflag = !joyUflag;
}
