/* Konstantinos Fane
 * kf289@kent.ac.uk
 * ID: 20901830
 */

/* timing.cpp api verion 1.01 */
/* wajw  21/03/18  */
//V 1.02 mod to just do period measurement edh 24/03/18
/* Prog to measure period of rotation of flywheel */

/* Software uses Pin 9 as an interrupt to determine rotation period */
/* A ticker is used to give a count of elapsed time */

/* Interrupt occurs on +ve edge of TDC Pulse on pin10 */
/* ISR Stores ticker count value as 'period', resets 'count' and sets flag */

#include "mbed.h"
#include "C12832_lcd.h"
#define counts_per_min 600000 // .1ms clock = 600k pulses minute

// Advance degree and RPM data arrays:

// advance angles in degrees BTDC 
static int map[] = {5,5,6,10,15,15,21,25,27,34,38};
// rpm range for which the advance angle should change 
static int rpm_range[] = {500,600,700,800,900,1000,1100,1200,1300,1400,1500};

// Global Variables:

volatile int  period = 0, count1 = 0;
volatile int pflag = 0, rpm = 0;

// Student added global variables:

int lag;                // to be used to calculate the ignition lag
int spark_advance;      // to be used for the advance degree input

C12832_LCD lcd;

// Function Prototypes:

void Tick1_isr (void);  // ISR for Ticker interrupt
void TDC_isr (void);    // ISR for rising edge of TDC interrupt
void Spark_on (void);   // set the output Spark (p10) high
void Spark_off (void);  // set it low
void Ignition(int); 

// Custom function prototypes:

void advance_calculator(int);


// Hardware Definitions:

Ticker Tick;            // Tick produces a periodic interrupt
DigitalOut Spark(p10);  // Spark Output to Flywheel Board
InterruptIn tdc(p9);    // Pulse from TDC Sensor on Flywheel Board

Timeout StartSpark;     // one-off interrupt to set spark o/p high
Timeout EndSpark;       // and this one sets spark low

// Function Declarations:

// triggers ignition spark based on the current advance angle provided
void Ignition(int lag)
{
    StartSpark.attach_us(&Spark_on, lag) ;      // set time of Spark 
    EndSpark.attach_us(&Spark_off, lag + 200);  // set spark duration at 200usec
}
    
void Spark_on()
{
    Spark = 1;
}

void Spark_off()
{
    Spark = 0;
}

/* Interrupt cause by Ticker
 * Increments count every 100usec
 */
void Tick1_isr()
{
     count1++;   
}

/* Interrupt caused by +ve edge on TDC 
 * Captured value = period
 */
void TDC_isr()
{
    period = count1;    // Capture time since last TDC
    count1 = 0;
    pflag = 1;          // New value of period available
}

//Custom functions declaration:

/* calculates the advance angle */
void advance_calculator(int rpm)
{
    if(rpm < rpm_range[0])
    {
        // advance angle for any speeds lower than 500 RPM
        spark_advance = 360 - map[0];
    }
    else if(rpm >= rpm_range[0] && rpm < rpm_range[1])
    {
        spark_advance = 360 - map[0];
    }
    else if(rpm >= rpm_range[1] && rpm < rpm_range[2])
    {
        spark_advance = 360 - map[1];
    }
    else if(rpm >= rpm_range[2] && rpm < rpm_range[3])
    {
        spark_advance = 360 - map[2];
    }
    else if(rpm >= rpm_range[3] && rpm < rpm_range[4])
    {
        spark_advance = 360 - map[3];
    }
    else if(rpm >= rpm_range[4] && rpm < rpm_range[5])
    {
        spark_advance = 360 - map[4];
    }
    else if(rpm >= rpm_range[5] && rpm < rpm_range[6])
    {
        spark_advance = 360 - map[5];
    }
    else if(rpm >= rpm_range[6] && rpm < rpm_range[7])
    {
        spark_advance = 360 - map[6];
    }
    else if(rpm >= rpm_range[7] && rpm < rpm_range[8])
    {
        spark_advance = 360 - map[7];
    }
    else if(rpm >= rpm_range[8] && rpm < rpm_range[9])
    {
        spark_advance = 360 - map[8];
    }
    else if(rpm >= rpm_range[9] && rpm < rpm_range[10])
    {
        spark_advance = 360 - map[9];
    }
    else 
    {
        // advance angle for speeds higher than 1500RPM(same angle as 1500RPM)
        spark_advance = 360 - map[10];
    }
}
    
 
int main()
{ 

    /* Produce regular clock tick for timing period:
     * initializes the ticker with period of 100usec
     * and attaches it to Tick1 ISR
     */
    Tick.attach_us(&Tick1_isr, 100);

    tdc.rise(&TDC_isr); // Generate Interrupt on each TDC pulse
     
    while(1) 
    {
       
       // spark advance calculation = TDC point(360) - desired advance angle 
       //spark_advance = 360 - 15;
        
       // function to calculate the spark advance for variating RPM speeds
       // on every itteration
       advance_calculator(rpm);
       
       // checks if new timing data is available
       if (pflag == 1)
       {  
            //lag = (period*100)*180/360; // Period in units of 100usec
            lag = (period*100)*spark_advance/360; // Period in units of 100usec
            Ignition(lag); //triggers ignition spark for given advance angle
            
            /* RPM calculation command
             * RPM = f(Hz) * 60 = (1/T() * 60
             * 1 period = 1*100us(period counter incrments every 100us, 
             * this conversion is needed to get the Hz frequency
             */
            rpm = (1/(period*100e-6))*60;
            
            /* "lcd.cls();" was moved inside the while()
             * to fix a bug in the display, by refreshing
             * the screen at every itteration
             */
            lcd.cls();
            
            // divided by 10 to display captured period same as the osciloscope
            lcd.locate(0,0);
            lcd.printf("Period(T): %4.2d ms", period/10); 
            
            // display the captured RPM 
            lcd.locate(0,11);
            lcd.printf("Speed(RPM): %4.2d ", rpm); 
            
            // display the advance angle for troubleshooting purposes
            // 360 - spark advance = advance angle in BTDC (reverse operation)
            lcd.locate(0,22);
            lcd.printf("Advance(deg): %4.2d ", 360-spark_advance);
            pflag = 0; //reset flag 
        }
         
    }
}

