//=================================================================
// Implementation for the player module
//
// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//==================================================================
#include "player_private.h"
#include "globals.h"
#include "compost_pile_public.h";
#define X 0xFFFFFF //WHITE
#define PLAYER_WIDTH 15
#define KNIFE_HEIGHT 2
#define KNIFE_WIDTH 12
#define _ 0x000000 //BLACK

PLAYER player; // structure of player


int player_sprite[PLAYER_HEIGHT * PLAYER_WIDTH] = {
 X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
 X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,
 X,_,_,_,_,X,X,X,_,_,_,_,_,_,_,
 X,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
 X,_,_,_,_,_,_,X,X,_,_,_,_,_,_,
 X,_,_,_,_,_,_,X,X,X,_,_,_,_,_,
 X,_,_,_,_,_,_,_,X,X,_,_,_,_,_,
 X,_,_,_,_,_,_,_,X,X,_,_,_,_,_,
 X,_,_,_,_,_,_,X,X,X,_,_,_,_,_,
 X,_,_,_,_,_,_,X,X,_,_,_,_,_,_,
 X,_,_,_,_,_,X,X,X,_,_,_,_,_,_,
 X,_,_,_,_,X,X,X,_,_,_,_,_,_,_,
 X,_,_,_,X,X,X,_,_,_,_,_,_,_,_,
 X,X,X,X,X,X,_,_,_,_,_,_,_,_,_,
};

int player_mask[PLAYER_HEIGHT * PLAYER_WIDTH] = {
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
 _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,

};

int knife_sprite[KNIFE_HEIGHT * KNIFE_WIDTH] = {
X,X,X,X,X,X,X,X,X,X,X,X,
X,X,X,X,X,X,X,X,X,X,X,X,

};

int knife_mask[KNIFE_HEIGHT * KNIFE_WIDTH] = {
_,_,_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,_,_,

};




PLAYER player_get_info(void){
    return player;
}

void player_init(void) {

    player.score = 0;
    player.height = PLAYER_HEIGHT;
    player.y = 0;
    player.player_has_knife = true;
    player.knife_length = KNIFE_WIDTH;
    player.strikes = 7;
    
    point topLeftP;
    point bottomRightP;
    topLeftP.x = 0;
    topLeftP.y = player.y + 6;
    bottomRightP.x =  12;
    bottomRightP.y =  player.y + 7;
    
    boundingBox knifeBox;
    knifeBox.topLeft = topLeftP;
    knifeBox.bottomRight = bottomRightP;
    player.knife_boundingBox = knifeBox;
    
    player_draw(0xFFFFFF);
    player_knife_draw();

}

void player_move(double x_acc) {
    int y_pos;
    y_pos = player.y + (-1 * x_acc * 20);
    if (y_pos < 10) {
        y_pos = 10;   
    }
    if (y_pos > 112 - (get_compost_tallest_height() * 11)) {
        y_pos = 112 - (get_compost_tallest_height() * 11);
    }
    int y_prev = player.y;
    player.y = y_pos;
    uLCD.BLIT(0,y_prev, PLAYER_WIDTH, PLAYER_HEIGHT, player_mask);
    uLCD.BLIT(0,y_pos, PLAYER_WIDTH, PLAYER_HEIGHT, player_sprite);
    
    if (player.player_has_knife) {
        uLCD.BLIT(0, y_prev + 6, KNIFE_WIDTH, KNIFE_HEIGHT, knife_mask);
        uLCD.BLIT(0, y_pos + 6, KNIFE_WIDTH, KNIFE_HEIGHT, knife_sprite);
        
        player.knife_boundingBox.topLeft.y = y_pos + 6;
        player.knife_boundingBox.bottomRight.y = y_pos + 7;
         player.knife_boundingBox.topLeft.x = 0;
        player.knife_boundingBox.bottomRight.x = 11;
        
        
    } else {
        point currTopLeft = player.knife_boundingBox.topLeft;
        
        player.knife_boundingBox.topLeft.x += 4;
        player.knife_boundingBox.bottomRight.x += 4;
        
        if (player.knife_boundingBox.bottomRight.x >= 125) {
            player.player_has_knife = true;
            uLCD.BLIT(currTopLeft.x, currTopLeft.y, KNIFE_WIDTH, KNIFE_HEIGHT, knife_mask);
            uLCD.BLIT(0, y_pos + 6, KNIFE_WIDTH, KNIFE_HEIGHT, knife_sprite);
            player.knife_boundingBox.topLeft.y = y_pos + 6;
            player.knife_boundingBox.bottomRight.y = y_pos + 7;
            player.knife_boundingBox.topLeft.x = 0;
            player.knife_boundingBox.bottomRight.x = 12;
            player.strikes--;
            
        } else {
            uLCD.BLIT(currTopLeft.x, currTopLeft.y, KNIFE_WIDTH, KNIFE_HEIGHT, knife_mask);
            uLCD.BLIT(player.knife_boundingBox.topLeft.x, currTopLeft.y, KNIFE_WIDTH, KNIFE_HEIGHT, knife_sprite);
        }
        
    
    }
    
    


}

void player_moveDown(void) { 

}

void player_throw(void) {
    if (player.player_has_knife) {
        player.player_has_knife = false; 
    } 
}

void player_knife_draw(void) {
    uLCD.BLIT(0, player.y + 6, KNIFE_WIDTH, KNIFE_HEIGHT, knife_sprite);
 
}

void player_knife_return(void) {
    player.player_has_knife = true;
    uLCD.BLIT(player.knife_boundingBox.topLeft.x, player.knife_boundingBox.topLeft.y, KNIFE_WIDTH, KNIFE_HEIGHT, knife_mask);
    player.knife_boundingBox.topLeft.x = 0;
    player.knife_boundingBox.topLeft.y = player.y + 6;

}

// ==== player_private.h implementation ====
void player_draw(int color) {
    uLCD.BLIT(0, player.y, PLAYER_WIDTH, PLAYER_HEIGHT, player_sprite); 
}

void player_score_inc(void) {

}

int get_player_strikes() {
    return player.strikes;
}
