#include "graphics.h"
#include "globals.h"

#define YELLOW 0xFFFF00
#define GREEN 0x00FF00
#define WHITE 0xFFFFFF
#define BLACK 0x000000
#define BROWN  0xD2691E
#define DIRT   BROWN
#define RED    0xFF0000
#define ORANGE 0xFFA500
#define X 0xFF0000
#define _ 0x000000
#define W 0xFFFFFF
#define O 0xFD6A02
#define G 0x00FF00
#define B 0x664229
#define Y 0xFFFF00


int bomb_sprite[10 * 10] = {
_,_,_,_,_,X,X,X,X,X,
_,_,_,X,X,X,X,_,_,X,
_,_,_,X,X,X,X,_,_,_,
_,X,X,X,X,X,X,X,X,_,
X,X,X,X,X,X,X,X,X,X,
X,X,X,X,X,X,X,X,X,X,
X,X,X,X,X,X,X,X,X,X,
X,X,X,X,X,X,X,X,X,X,
_,X,X,X,X,X,X,X,X,_,
_,_,X,X,X,X,X,X,_,_,
};

int orange_sprite[10 * 10] = {
_,G,G,G,B,B,_,_,_,_,
_,_,_,_,B,B,_,_,_,_,
_,O,O,O,O,O,O,O,O,_,
O,O,O,O,O,O,O,O,O,O,
O,O,O,O,O,O,O,O,O,O,
O,O,O,O,O,O,O,O,O,O,
O,O,O,O,O,O,O,O,O,O,
O,O,O,O,O,O,O,O,O,O,
_,O,O,O,O,O,O,O,O,_,
_,_,O,O,O,O,O,O,_,_,
};

int apple_sprite[10 * 10] = {
_,G,G,G,B,B,_,_,_,_,
_,_,_,_,B,B,_,_,_,_,
_,G,G,G,G,G,G,G,G,_,
G,G,G,G,G,G,G,G,G,G,
G,G,G,G,G,G,G,G,G,G,
G,G,G,G,G,G,G,G,G,G,
G,G,G,G,G,G,G,G,G,G,
G,G,G,G,G,G,G,G,G,G,
_,G,G,G,G,G,G,G,G,_,
_,_,G,G,G,G,G,G,_,_,
};

int banana_sprite[10 * 10] = {
_,_,_,_,_,_,_,_,B,B,
_,_,_,_,_,_,_,_,B,B,
_,_,_,_,_,_,_,B,B,B,
_,_,_,_,_,Y,Y,Y,Y,Y,
_,_,_,_,Y,Y,Y,Y,Y,Y,
_,_,Y,Y,Y,Y,Y,Y,Y,_,
Y,Y,Y,Y,Y,Y,Y,Y,_,_,
Y,Y,Y,Y,Y,Y,Y,_,_,_,
Y,Y,Y,Y,Y,_,_,_,_,_,
};

int fruit_mask[10 * 10] = {
_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,
_,_,_,_,_,_,_,_,_,_,

};


void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++)
    {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = YELLOW;
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'D') colors[i] = DIRT;
        // else if (img[i] == '5') colors[i] = LGREY;
        // else if (img[i] == '3') colors[i] = DGREY;
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}

void draw_player(int u, int v, int key)
{
    uLCD.filled_rectangle(u, v, u+11, v+11, WHITE);
}

void draw_nothing(boundingBox b)
{
    // Erase a bounding box
    //uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.bottomRight.x, b.bottomRight.y, BLACK);
    uLCD.BLIT(b.topLeft.x, b.topLeft.y, 10, 10, fruit_mask);
}

void draw_bomb(boundingBox b)
{
    // Draw an apple using a filled_rectangle or get creative and use a sprite!
    //uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.bottomRight.x, b.bottomRight.y, RED);
    uLCD.BLIT(b.topLeft.x, b.topLeft.y, 10, 10, bomb_sprite);
}

void draw_banana(boundingBox b)
{
    // Draw a banana using a filled_rectangle or get creative and use a sprite!
    //uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.bottomRight.x, b.bottomRight.y, YELLOW);
    uLCD.BLIT(b.topLeft.x, b.topLeft.y, 10, 10, banana_sprite);
}

void draw_orange(boundingBox b)
{
// Draw an orange using a filled_rectangle or get creative and use a sprite!
    //uLCD.filled_rectangle(b.topLeft.x, b.topLeft.y, b.bottomRight.x, b.bottomRight.y, ORANGE);
    uLCD.BLIT(b.topLeft.x, b.topLeft.y, 10, 10, orange_sprite);
}

void draw_apple(boundingBox b) {
    uLCD.BLIT(b.topLeft.x, b.topLeft.y, 10, 10, apple_sprite);    
}


