//=================================================================
// Implementation for DLL module.
//
// Copyright 2021 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//=================================================================
#include <stdlib.h>
#include <stdio.h>
#include "doubly_linked_list.h"
#include "globals.h"

LLNode* create_llnode(void* data) {

    // Your code here
    LLNode* newNode = (LLNode*)malloc(sizeof(LLNode));
    if (newNode == NULL) {
      pc.printf("Error: Insufficient Space");
      exit(1);
    }

    newNode->data = data;
    newNode->next = NULL;
    newNode->prev = NULL;
    return newNode; 
}

DLinkedList* create_dlinkedlist(void) {
    DLinkedList* newList = (DLinkedList*)malloc(sizeof(DLinkedList));
    newList->head = NULL;
    newList->tail = NULL;
    newList->size = 0;
    return newList;
}

int getSize(DLinkedList* dLinkedList){

  // Your code here
  return dLinkedList->size;
}

LLNode* getHead(DLinkedList* dLinkedList){

  // Your code here

  return dLinkedList->head;
}

LLNode* getTail(DLinkedList* dLinkedList){

  // Your code here

  return dLinkedList->tail;
}

LLNode* getNext(LLNode* node){

  // Your code here

  return node->next;
}

LLNode* getPrev(LLNode* node){

  // Your code here

  return node->prev;
}

void* getData(LLNode* node){

  // Your code here

  return node->data;
}

void insertAfter(DLinkedList* dLinkedList, LLNode* prev_node, void* data){
  if (prev_node == NULL) {
    printf("the given previous node cannot be NULL");
    return;
  }

  LLNode* newNode = create_llnode(data);

  if (prev_node->next == NULL) { //inserting new tail
    prev_node->next = newNode;
    newNode->prev = prev_node;
    dLinkedList->tail = newNode;
  } else {
    LLNode* temp = prev_node->next;
    prev_node->next = newNode;
    newNode->next = temp;
    newNode->prev = prev_node;
    temp->prev = newNode;
  }
  dLinkedList->size++;
  
}

void insertBefore(DLinkedList* dLinkedList, LLNode* next_node, void* data){
  if (next_node == NULL) {
    //printf("the given next node cannot be NULL");
    return;
  }

  LLNode* newNode = create_llnode(data);
  if (next_node->prev == NULL) { //inserting new head
    //pc.printf("debug1\n");
    newNode->next = dLinkedList->head;
    dLinkedList->head->prev = newNode;
    dLinkedList->head = newNode;
  } else {
    LLNode* temp = next_node->prev;
    next_node->prev = newNode;
    newNode->next = next_node;
    newNode->prev = temp;
    temp->next = newNode;
  }
  dLinkedList->tail->next = NULL;
  dLinkedList->head->prev = NULL;
  
  dLinkedList->size++;
  
  
}

void insertHead(DLinkedList* dLinkedList, void* data){
  //pc.printf("Adding new node: %d\n", data);
  if(dLinkedList->head == NULL){
    LLNode* newNode = create_llnode(data);
    dLinkedList->head = newNode;
    dLinkedList->tail = newNode;
    dLinkedList->size++; 
  }else{
    insertBefore(dLinkedList, dLinkedList->head, data);
  }
  //printLinkedList(dLinkedList);
}

void insertTail(DLinkedList* dLinkedList, void* data){
  if (dLinkedList->head == NULL) {
    LLNode* newNode = create_llnode(data);
    dLinkedList->head = newNode;
    dLinkedList->tail = newNode;
    dLinkedList->size++;
  } else {
    insertAfter(dLinkedList, dLinkedList->tail, data);
  }
  
}

void deleteNode(DLinkedList* dLinkedList, LLNode* Node){
    if (Node == NULL) {
      pc.printf("Error: Node is null");
      
      return;
    }
    if (dLinkedList->size == 1) { //list size 1
       //pc.printf("Deleting Single node: %d\n", Node->data);
       dLinkedList->head = NULL;
       dLinkedList->tail = NULL;
    
    } else if (Node->next == NULL) { //it is the tail
      //pc.printf("Deleting Tail node: %d\n", Node->data);
      dLinkedList->tail = Node->prev;
      dLinkedList->tail->next = NULL;
    } else if (Node->prev == NULL) { //it is the head
      //pc.printf("debug delete 1\n");
      //pc.printf("Deleting Head node: %d\n", Node->data);
      dLinkedList->head = Node->next;
      dLinkedList->head->prev = NULL;
      Node->prev = NULL;
    } else {
      //pc.printf("Deleting middle node: %d\n", Node->data);
      //pc.printf("debug delete 3\n");
      Node->next->prev = Node->prev;
      //pc.printf("debug delete 4\n");
      Node->prev->next = Node->next;
      //dLinkedList->tail->next = NULL;
      
    }
    dLinkedList->size--;
    free(Node);
    //printLinkedList(dLinkedList);
}

void destroyList(DLinkedList* dLinkedList){
  free(dLinkedList);

}

void printLinkedList(DLinkedList* dLinkedList) {
    LLNode* current = dLinkedList->head;
    if (dLinkedList->head == NULL) {
        pc.printf("Empty List\n");
        return;
    }
    pc.printf("head -> ");
    while (current->next != NULL) {
        pc.printf("Node: %d -> ", current->data);
        current = current->next;
    }
    pc.printf("Node: %d <- tail\n", current->data);
}

void reverse(DLinkedList* dLinkedList) {

  if (dLinkedList->size == 1 ) {
    return;
  }
  if (dLinkedList->size == 0) {
    printf("Error: Cannot reverse an empty list");
    return;
  }

  LLNode* current = dLinkedList->head;
  LLNode* temp = NULL;

  dLinkedList->tail = current;

  while(current != NULL) {
    temp = current->prev;
    current->prev = current->next;
    current->next = temp;
    current = current->prev;
  }

  dLinkedList->head = temp->prev;

}     

