//=================================================================
// The file is for module "compost pile"
//
// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//==================================================================

#include "compost_pile_private.h"
#define MAX_PILE_HEIGHT 4
#include "globals.h"
#include "graphics.h"

COMPOST compost_record[NUM_PILE];
int tallest_pile_height;





// See the comments in compost_pile_public.h
void compost_pile_init() {
    int x = 0;
    for (int i = 0; i < NUM_PILE; i++) {
        compost_record[i].width = PILE_WIDTH;
        compost_record[i].height = 0;
        compost_record[i].box.topLeft.x = x;
        compost_record[i].box.topLeft.y = 127;
        compost_record[i].box.bottomRight.x = x + PILE_WIDTH;
        compost_record[i].box.bottomRight.y = 127; 
        //pc.printf("(%d, %d)\n",compost_record[i].box.bottomRight.x, 127);
        x += PILE_WIDTH + 1;
    }
    tallest_pile_height = 0;
    draw_compost();

    

}

COMPOST compost_get_info(int index){
    return compost_record[index];
}

int get_num_piles() {
    return NUM_PILE;
}

void compost_add(int index) {
    compost_record[index].height++;
    compost_record[index].box.topLeft.y = 127 - (PILE_WIDTH * compost_record[index].height);
    if (compost_record[index].height > tallest_pile_height) {
        tallest_pile_height = compost_record[index].height;
    }

}

void draw_compost(){
    for (int i = 0; i < NUM_PILE; i++) {
        uLCD.filled_rectangle(compost_record[i].box.topLeft.x, compost_record[i].box.topLeft.y, compost_record[i].box.bottomRight.x, compost_record[i].box.bottomRight.y, COMPOST_COLOR);
    }  

}

int get_compost_tallest_height() {
    return tallest_pile_height;

}

int get_compost_height(int index) {
    return compost_record[index].height;
}

bool check_overflow() {
    return (tallest_pile_height > MAX_PILE_HEIGHT); 
    
}

void remove_tallest_pile() {
    int new_tallest = 0;
    for (int i = 0; i < NUM_PILE; i++) {
        if (get_compost_height(i) == tallest_pile_height) {
            uLCD.filled_rectangle(compost_record[i].box.topLeft.x, compost_record[i].box.topLeft.y, compost_record[i].box.bottomRight.x, compost_record[i].box.bottomRight.y, BLACK);
            compost_record[i].height = 0;
            compost_record[i].box.topLeft.y = 127;    
        } 
        
        if (compost_record[i].height > new_tallest) {
            new_tallest = compost_record[i].height;
        }
    }
    
    tallest_pile_height = new_tallest;
        
    
}

