#include "mbed.h"
#include "MDM.h"
#include "HTTPClient.h"
#include "M2XStreamClient.h"

// M2X stuff
char feedId[] = "c6eabf437b8c69efbb4e4a8d5c60c04d"; // Feed you want to post to
char m2xKey[] = "10bc8a4dc4a37c5dc549b41ffaa6d6c1"; // Your M2X access key
char streamName[] = "danger_bit"; // Stream you want to post to

// Connected Car stuff
char ccUser[] = "provider";
char ccPass[] = "1234";
char ccOnUrl[]  = "http://toy.hack.att.io:3000/remoteservices/v1/vehicle/engineOn/1234567890abcd";
char ccOffUrl[] = "http://toy.hack.att.io:3000/remoteservices/v1/vehicle/engineOff/1234567890abcd";

Ticker sensortick;

DigitalOut heat(P2_13);
AnalogIn sensor(P0_23);

int volatile reading;
bool volatile newReading = false;

void sensor_isr()
{
    reading = (int)(sensor.read() * 1000);
    newReading = true;
}

int main() 
{
    MDMSerial mdm;
    
    Client client;
    M2XStreamClient m2xClient(&client, m2xKey);
    
    DigitalOut led(LED);
    
    led = 1;
    sensortick.attach(sensor_isr, 2);
    heat = 1;
    
    printf("\nConnecting...\n");
    
    //mdm.setDebug(4); // enable this for debugging issues 
    if (!mdm.connect())
    {
        printf("Connect failed!\n");
        return -1;
    }
    
    led = 0;
    printf("Connected!\n");
    set_time(0);
    
    HTTPClient http;
    HTTPMap map;
    char str[512];
    HTTPText inText(str, 512);
    int ret;
    
    http.basicAuth(ccUser, ccPass);
    http.customHeaders(NULL, 0);
    
    printf("\nTurning on engine...\n");
    do
    {
        ret = http.post(ccOnUrl, map, &inText, 15000);
        if (!ret)
        {
          printf("Executed POST successfully - read %d characters\n", strlen(str));
          printf("Result: %s\n", str);
        }
        else
        {
          printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
    } while (ret);
    
    time_t seconds;
    
    int currentReading, highReading = 1000, prevReading = 1000;
    bool alarm = true;
    unsigned int wait = 15;
    
    while (1)
    {     
        if (newReading)
        {
            led = 1;
            currentReading = reading; // make a copy because the isr might update it before we're done here
            seconds = time(NULL);
            printf("%d:%02d:%02d:%02d ", seconds / 86400, (seconds / 3600) % 24, (seconds / 60) % 60, seconds % 60);
            printf("Alarm: %s Reading: %d (prev: %d; high: %d)\n", (alarm ? "yes" : "no"), currentReading, prevReading, highReading);
            
            if (!alarm && ((currentReading - prevReading) > 50))
            {
                // rise since previous reading
                printf("*** Danger!\n");
                
                printf("Turning off engine...\n");
                do
                {
                    ret = http.post(ccOffUrl, map, &inText, 15000);
                    if (!ret)
                    {
                      printf("Executed POST successfully - read %d characters\n", strlen(str));
                      printf("Result: %s\n", str);
                    }
                    else
                    {
                      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
                    }
                } while (ret);
                
                do
                {
                    printf("Reporting danger...\n");
                    ret = m2xClient.post(feedId, streamName, 1);
                    printf("Post response code: %d\n", ret);
                } while (ret != 204);
                
                highReading = currentReading;
                alarm = true;
                wait = 0;
            }
            else if (alarm && ((highReading - currentReading) > 50))
            {
                wait++;
                if (wait > 15) // 30 s
                {
                    // fall since last high reading
                    printf("*** Safe!\n");
                    
                    
                    do
                    {
                        printf("Reporting safe...\n");
                        ret = m2xClient.post(feedId, streamName, 0);
                        printf("Post response code: %d\n", ret);
                    } while (ret != 204);
                    
                    alarm = false;
                }
            }
            prevReading = currentReading;
            newReading = false;
            led = 0;
        }
    }

    /*mdm.disconnect();
    mdm.powerOff();

    while (1);*/
}