#include "PowerControl.h"

extern RawSerial pc;
//extern DigitalOut ledError;

PowerControl::PowerControl(PinName button):
    _button(button), _canControl(BUCK2)
{
    enabled = false;
    
    _button.setSamplesTillHeld( 200 );
    _button.attach_asserted_held( this, &PowerControl::goSleep );
    _button.attach_asserted( this, &PowerControl::goWakeup );

    goWakeup();
}

void PowerControl::goSleep(){
#ifdef DEBUG
    pc.printf("going to sleep\r\n");
#endif
    enabled = false;
    
    //while(!biemDisable());
    while(!_canControl.disable()); // must be last
    
#ifdef DEBUG
    pc.printf("zzzzzzzzz.....r\n");
#endif

    sleep();
}

void PowerControl::goWakeup(){
    if(!enabled){
#ifdef DEBUG
        pc.printf("waking up\r\n");
#endif
    while(!_canControl.enable()); // must be first
    //while(!biemEnable());


#ifdef DEBUG
        pc.printf("fully awake\r\n");
#endif
    }
}
