#ifndef POWERCONTROL_H
#define POWERCONTROL_H

// uncomment to send debug information
#define DEBUG

#include "mbed.h"
// include 3rd party library
#include "PinDetect.h"
// include own libraries
#include "pinout.h"
#include "CanControl.h"

/** Power class
 *  Used to control the buck converters
 */
class PowerControl
{
    public:
    /** Create PowerControl instance
    @param Button
    */
    PowerControl(PinName button);
    
    private:
    /** goSleep
    Disables all the buck converters and sends a CAN message to deactivate relay
    */
    void goSleep(void);
    
    /** goWakeup
    Enables all the buck converters and sends a CAN message to activate relay
    */
    void goWakeup(void);
    
    /** Returns the status of the Canbus
    1 = enabled, 0 = disabled
    */
    bool status(void){return enabled;}
    
    PinDetect _button;
    CanControl _canControl;
    bool enabled;
};


    
#endif //POWERCONTROL_H