#include "CanControl.h"

extern RawSerial pc;
extern CAN can;

CanControl::CanControl(PinName buckCan):
    _buckCan(buckCan), _canEnable(CAN_ENABLE), _ledRelay(LED2)
{
    enabled = false;
    repeat.attach(this, &CanControl::relay, 1.0);
}

bool CanControl::disable(void){
#ifdef DEBUG
    pc.printf("disabling CAN\r\n");
#endif
    enabled = false;
    can.write(CANMessage(BMSCANADDRESS, "0"));
    wait_ms(100);
    _canEnable = 0;
    _buckCan = 0;
    _ledRelay = 0;
    return true;
}

bool CanControl::enable(void){
#ifdef DEBUG
    pc.printf("enabling CAN\r\n");
#endif
    enabled = true;
    _buckCan = 1;
    _canEnable = 1;
    _ledRelay = 1;
    wait_ms(100);
    can.write(CANMessage(BMSCANADDRESS, "1"));
    return true;
}

void CanControl::relay(void){
    if(enabled){
#ifdef DEBUG
        pc.printf("CANMessage sent: BMSCANADDRESS, \"1\"\r\n");
#endif
        can.write(CANMessage(BMSCANADDRESS, "1"));
    }
}

