#ifndef CANCONTROL_H
#define CANCONTROL_H

// uncomment to send debug information
#define DEBUG

#include "mbed.h"
// include own libraries
#include "pinout.h"

#define BMSCANADDRESS 0x033

/** CanControl class
 *  Used to control the power on the CanBus
 */
class CanControl
{
    public:
    /** Create CanControl instance
    @param buck converter pin
    */
    CanControl(PinName buckCan);
    
    /** Disables/shuts down the Can bus
    */
    bool disable(void);
    
    /** Enables/turn on the Can bus
    */
    bool enable(void);
    
    /** Returns the status of the Canbus
    1 = enabled, 0 = disabled
    */
    bool status(void){return enabled;}
    
    private:
    /** Keep relay enabled
    makes sure the relay stays enabled when the enable function is called
    this happens by pinging the BMS every second (CAN address 0x033)
    */
    void relay(void);
    
    DigitalOut _buckCan;
    DigitalOut _canEnable;
    DigitalOut _ledRelay;
    Ticker repeat;
    bool enabled;    
};

#endif //CANCONTROL_H