#include "mbed.h"
#include "C12832.h"
#include "LM75B.h"



//------------------------------------------------------------------------//
// Hardware Variables                                                     //
//------------------------------------------------------------------------//
Serial      rn41    (p9,p10);
Serial      pc      (USBTX,USBRX);
C12832      lcd     (p5, p7, p6, p8, p11);
LM75B       sensor  (p28,p27);
//BusOut      led     (LED4,LED3,LED2,LED1);
DigitalOut  led1    (LED1);
DigitalOut  led2    (LED2);
DigitalOut  led3    (LED3);
DigitalOut  led4    (LED4);
AnalogIn    pot(p19);
AnalogIn    pot2(p20);


//------------------------------------------------------------------------//
// Function Headears                                                      //
//------------------------------------------------------------------------//
void    bluetoothReceive    ();
void    setupBluetooth      ();


char buff[100];

//------------------------------------------------------------------------//
// Functions                                                              //
//------------------------------------------------------------------------//

float read_temp()
{

    if (sensor.open()) {
        printf("Device detected!\n");

        while (1) {
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Temp = %.3f\n", (float)sensor);
            return sensor;
        }
    } else {
        error("Device not detected!\n");
        return -1;
    }

}



void bluetoothReceive   ()
{
    char caracter;
    float t;

    memset (buff,'\0',sizeof(buff));
    lcd.locate(10,15);
    lcd.printf(": wait msg");
    while (rn41.readable()) {
        caracter = rn41.getc();
        rn41.putc(caracter);
        buff[strlen(buff)]= caracter;
        led3 = 1;
    }
    lcd.locate(10,15);
    lcd.printf(": %s",buff);
    led1 = 0;
    if(buff[0] == 't') {
        led2 = 1;
        t = read_temp();
        caracter = t;
        rn41.putc(caracter);
    }
}

void setupBluetooth     ()
{
        lcd.locate(10,15);
    lcd.printf(": setu");
    rn41.baud(115200);
    rn41.format(8,SerialBase::None,1);
    rn41.attach(&bluetoothReceive, Serial::RxIrq);
}


//void executing_thread(){




//}



//------------------------------------------------------------------------//
// Main                                                                   //
//------------------------------------------------------------------------//
int main()
{
    memset (buff,'\0',sizeof(buff));
    lcd.cls();

    setupBluetooth();
    //Thread executing(executing_thread);

    pc.baud(9600);

    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("I'm the MBED board!");
    led1=1;



}