#include "mbed.h"

class MMA7361L {
public:
    MMA7361L(PinName xoutPin, PinName youtPin,PinName zoutPin,
             PinName zeroGDetectPin, PinName gSelectPin, PinName sleepPin);

    enum Scale {SCALE_1_5G, SCALE_6G};
    float getAccel();
    float getAccelX();
    float getAccelY();
    float getAccelZ();
    float getTiltX();
    float getTiltY();
    float getTiltZ();
    void setScale(Scale scale);
    void setSleep(bool on);
    bool zeroGDetected();
    void setZeroGDetectListener(void (*func)(void));
    template<typename T> void setZeroGDetectListener(T* t, void (T::*func)(void));

private:
    AnalogIn xout, yout, zout;
    InterruptIn zeroGDetect;
    DigitalOut gSelect;
    DigitalOut sleep;
    float scale;
};
