#include "MMA7361L.h"

MMA7361L::MMA7361L(PinName xoutPin, PinName youtPin,PinName zoutPin,
                   PinName zeroGDetectPin, PinName gSelectPin, PinName sleepPin) :
        xout(xoutPin), yout(youtPin), zout(zoutPin),
        zeroGDetect(zeroGDetectPin), gSelect(gSelectPin), sleep(sleepPin) {
    setSleep(false);
    setScale(SCALE_1_5G);
}

float MMA7361L::getAccel() {
    float accelX = ((xout * 3.3) - 1.65) / scale;
    float accelY = ((yout * 3.3) - 1.65) / scale;
    float accelZ = ((zout * 3.3) - 1.65) / scale;
    return sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ);
}

float MMA7361L::getAccelX() {
    return ((xout * 3.3) - 1.65) / scale;
}

float MMA7361L::getAccelY() {
    return ((yout * 3.3) - 1.65) / scale;
}

float MMA7361L::getAccelZ() {
    return ((zout * 3.3) - 1.65) / scale;
}

float MMA7361L::getTiltX() {
    float accelX = ((xout * 3.3) - 1.65) / scale;
    float accelY = ((yout * 3.3) - 1.65) / scale;
    float accelZ = ((zout * 3.3) - 1.65) / scale;
    return asin(accelX / sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ));
}

float MMA7361L::getTiltY() {
    float accelX = ((xout * 3.3) - 1.65) / scale;
    float accelY = ((yout * 3.3) - 1.65) / scale;
    float accelZ = ((zout * 3.3) - 1.65) / scale;
    return asin(accelY / sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ));
}

float MMA7361L::getTiltZ() {
    float accelX = ((xout * 3.3) - 1.65) / scale;
    float accelY = ((yout * 3.3) - 1.65) / scale;
    float accelZ = ((zout * 3.3) - 1.65) / scale;
    return asin(accelZ / sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ));
}

void MMA7361L::setScale(Scale scale) {
    switch (scale) {
        case SCALE_1_5G:
            this->scale = 0.8;
            gSelect = 0;
            break;
        case SCALE_6G:
            this->scale = 0.206;
            gSelect = 1;
            break;
    }
}

void MMA7361L::setSleep(bool on) {
    sleep = !on;
}

bool MMA7361L::zeroGDetected() {
    return zeroGDetect;
}

void MMA7361L::setZeroGDetectListener(void (*func)(void)) {
    zeroGDetect.rise(func);
}

template<typename T> void MMA7361L::setZeroGDetectListener(T* t, void (T::*func)(void)) {
    zeroG.rise(t, func);
}

