#include "mbed.h"

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

Serial pc(USBTX, USBRX);

extern "C"
void GINT1_IRQHandler(void) {
    LPC_GPIO_GROUP_INT1->CTRL |= (1<<0);
    NVIC_ClearPendingIRQ(GINT0_IRQn);
}

void initStartLogic (unsigned int p0, unsigned int p1) {
    LPC_SYSCON->SYSAHBCLKCTRL |= (1<<24);
    LPC_GPIO_GROUP_INT1->PORT_POL[0] = 0;
    LPC_GPIO_GROUP_INT1->PORT_POL[1] = 0;
    LPC_GPIO_GROUP_INT1->PORT_ENA[0] = p0;
    LPC_GPIO_GROUP_INT1->PORT_ENA[1] = p1;
    LPC_GPIO_GROUP_INT1->CTRL = 0; // Edge, OR, INT

    LPC_SYSCON->PDAWAKECFG = LPC_SYSCON->PDRUNCFG;

    LPC_SYSCON->STARTERP1 = (1<<21); // start logic GROUP1
    NVIC_ClearPendingIRQ(GINT1_IRQn);
    NVIC_EnableIRQ(GINT1_IRQn);
}

unsigned int setSystemMainClock(unsigned short S) {
    LPC_SYSCON->MAINCLKSEL    = S;     /* Select PLL Clock Output  */
    LPC_SYSCON->MAINCLKUEN    = 0x01;               /* Update MCLK Clock Source */
    LPC_SYSCON->MAINCLKUEN    = 0x00;               /* Toggle Update Register   */
    LPC_SYSCON->MAINCLKUEN    = 0x01;
    while (!(LPC_SYSCON->MAINCLKUEN & 0x01));       /* Wait Until Updated       */

    SystemCoreClockUpdate();
    return SystemCoreClock;
}

unsigned int setSystemFrequency(unsigned short M, unsigned short P) {
    LPC_SYSCON->SYSPLLCTRL = ((P & 0x03)<<5) | (M & 0x1f);
    while (!(LPC_SYSCON->SYSPLLSTAT & 0x01)); // Wait Until PLL Locked
    SystemCoreClockUpdate();
    return SystemCoreClock;
}

void PowerDown () {
    LPC_SYSCON->PDAWAKECFG = LPC_SYSCON->PDRUNCFG;
    LPC_PMU->PCON = (2<<0);
    SCB->SCR |= (1<<2);
    __WFI();
}

void DeepSleep () {
    LPC_SYSCON->PDAWAKECFG = LPC_SYSCON->PDRUNCFG;
    LPC_PMU->PCON = (1<<0);
    SCB->SCR |= (1<<2);
    __WFI();
}

void Sleep () {
    LPC_PMU->PCON = 0;
    SCB->SCR &= ~(1<<2);
    __WFI();
}

int main() {
    int i;

//    setSystemFrequency(3, 1); // M, P, 48MHz
//    setSystemFrequency(1, 2); // M, P, 24MHz

    LPC_GPIO->SET[1] = (1<<26);
    LPC_GPIO->DIR[1] |= (1<<26);

    pc.baud(9600);
    pc.printf("low power\r\n");

    for (i = 0; i < 6; i ++) {
        led1 = !led1;
        wait(0.2);
    }

    initStartLogic((1<<22)|(1<<1), 0); // p20(P0.22), ISP(P0.1)

    for (;;) {
    
        pc.printf("enter sleep\r\n");
        wait_ms(10);

        setSystemMainClock(0); // IRC clock
        LPC_GPIO->CLR[1] = (1<<26);
//        Sleep();
//        DeepSleep();
        PowerDown();

        LPC_GPIO->SET[1] = (1<<26);
        setSystemMainClock(3); // PLL clock

        pc.printf("wake up\r\n");
        for (i = 0; i < 6; i ++) {
            led1 = !led1;
            wait(0.2);
        }

        for (;;);

    }
}
