//ESC:TMM x2-series HV-160

#include "mbed.h"
#include "QEI.h"

void escset_up(void);
void ctd(void);
void init(void);

PwmOut ESC(p21);
Serial USB(USBTX, USBRX);
QEI ENC(p15,p16,NC,300, QEI::X4_ENCODING);

Timer tim_A;
Timer tim_B;
Timer tim_C;
#define MAX_PWM 1350
#define MOR_N 1000
int PWM = MOR_N;
int esc_type = 1;
/*
/esc-Setup
/Midlle
/High_duty
/Low_duty
*/

int main() {
        init();
        escset_up();
        ctd();
        
        tim_A.start();
        tim_C.start();
        //PWM = MOR_N;
        //ESC.pulsewidth_us(PWM);
        //USB.printf("%8d\r\n",PWM);
        while(1){
            if(tim_A.read_ms()>=100){
                tim_A.reset();
                tim_B.start();
           // USB.printf("Start!\r\n");
            PWM += 10;
            if(PWM >= MAX_PWM){
                PWM = MAX_PWM;
                }
           // PWM = MOR_N;
                
            ESC.pulsewidth_us(PWM);
        //USB.printf("Finish!\r\n");
        }
        else if(tim_B.read_ms()> 100){
            tim_B.reset();
            tim_A.reset();
            USB.printf("%d\t%8d\r\n",tim_C.read_ms(),PWM,ENC);
            }
        }
}


//middle,high,low
//high,low,middle
void escset_up(void) 
{
    switch(esc_type){
    case 0 :
    //TMM    
    USB.printf("ESC::TMM40063\n");
    USB.printf("Set_Middle_duty\n");
    ESC.pulsewidth_us(1500);
    wait(5);
    USB.printf("Set_High_duty\n");
    ESC.pulsewidth_us(1950);
    wait(5);
    USB.printf("Set_Low_duty\n");
    ESC.pulsewidth_us(1000);
    wait(5);
    USB.printf("Setup_over\n");
    wait(5);
    
    case 1:
    //HV-160
    USB.printf("ESC::HV-160\r\n");

    ESC.pulsewidth_us(1000);
    wait(1);
    USB.printf("Set-up Over!!!\r\n");

    break;

    }
}

/*--------------------------------------------------
* ctd()
* @Author: Kei Sugawara
* @Date  : 5.20.2016
* @Brief : start countdown
--------------------------------------------------*/
void ctd(void)
{
    int i;
    for (i = 5; i >= 0; i--) {
        ESC.pulsewidth_us(MOR_N);
        USB.printf("COUNT_DOWN:%d\n", i);
        wait(1);
    }
}

void init(void)
{
    // Start up message
    USB.printf("\n\rClimber Initialize\n");

    ESC.period_us(2000);
    wait(2);
}