#include "LAMPICE.h"
#include "mbed.h"
LAMPICE::LAMPICE(PinName LED1, PinName LED2, PinName trimer, PinName TIPKALO1, PinName LED3, PinName pwmpin2) : _LED1(LED1), _LED2(LED2), _trimer(trimer), _TIPKALO1(TIPKALO1), _LED3(LED3), _LED4(pwmpin2)
{
    _LED1 = 0;
    _LED2 = 0;
    _trimer;
    _TIPKALO1.rise(callback(this, &LAMPICE::button));
    _LED3.period(0.01);
    _LED4.period(0.01);
    _count;
    _blinker;
}

void LAMPICE::svjetla1(){
    float time;
    time=_trimer;
    
    for(float i=0; i<=100; i++){
    _LED3=i/100;
    wait(0.05*time);    
    }
        
    for(float i=100; i>=0; i--){
    _LED3=i/100;
    wait(0.05*time);    
    }
}

void LAMPICE::svjetla2(){
    float time;
    time=_trimer;
    
    for(float i=0; i<=100; i++){
    _LED4=i/100;
    wait(0.05*time);    
    }
        
    for(float i=100; i>=0; i--){
    _LED4=i/100;
    wait(0.05*time);    
    }
}

void LAMPICE::svjetla3(){
    float time;
    time=_trimer;
        
    for(float i=0; i<=100; i++){
    _LED3=i/100;
    wait(0.05*time);    
    }
        
    for(float i=0; i<=100; i++){
    _LED4=i/100;
    wait(0.05*time);    
    }
        
    for(float i=100; i>=0; i--){
    _LED3=i/100;
    _LED4=i/100;
    wait(0.05*time);    
    }
}

void LAMPICE::svjetla4(){
    _LED1=!_LED1;
    wait(1);
    _LED1=!_LED1;
    _LED2=!_LED2;
    wait(1);
    _LED2=!_LED2;
}

void LAMPICE::svjetla5(){
    float time;
    time=_trimer;
    
    _LED1=!_LED1;
    for(float i=0; i<=100; i++){
    _LED4=i/100;
    wait(0.025*time);    
    }
    
    _LED1=!_LED1;
    _LED2=!_LED2;
        
    for(float i=100; i>=0; i--){
    _LED4=i/100;
    wait(0.025*time);    
    }
    _LED2=!_LED2;
}

void LAMPICE::svjetla6(){
    float time;
    time=_trimer;
    
    _blinker.attach(callback(this, &LAMPICE::blink), 1);
    
    for(float i=0; i<=33; i++){
    _LED3=i/100;
    _LED4=i/100;
    wait(0.06*time);    
    }
    for(float i=34; i<=66; i++){
    _LED3=i/100;
    _LED4=i/100;
    wait(0.02*time);    
    }
    for(float i=67; i<=100; i++){
    _LED3=i/100;
    _LED4=i/100;
    wait(0.01*time);    
    }
      
    for(float i=100; i>=50; i--){
    _LED3=i/100;
    _LED4=i/100;
    wait(0.015*time);    
    }
    for(float i=49; i>=0; i--){
    _LED3=i/100;
    _LED4=i/100;
    wait(0.06*time);    
    }
    _blinker.detach();
    _LED1=0;
}

int LAMPICE::flash(int n)
{   
    _TIPKALO1.mode(PullDown);
            
    switch(_count){
        case 0:
            svjetla1();
            n=0;
            break;
        case 1:
            svjetla2();
            n=1;
            break;
        case 2:
            svjetla3();
            n=2;
            break;
        case 3:
            svjetla4();
            n=3;
            break;
        case 4:
            svjetla5();
            n=4;
            break;
        case 5:
            svjetla6();
            n=5;
            break;
        
    }
    
    if(_count>5){
        _count=0;
    }    
    return n;
}

void LAMPICE::button(){
    
    _count++;
}

void LAMPICE::blink(){
    _LED1=!_LED1;
}
            
    