#ifndef INIT_H_
#define INIT_H_

#include "QEI.h"


extern PwmOut  PWM0;
extern PwmOut  PWM1;
extern PwmOut  PWM2;
extern PwmOut  PWM3;
extern PwmOut  PWM4;
extern PwmOut  PWM5;
extern AnalogIn    AD0;
extern AnalogIn    AD1;
extern AnalogIn    AD2;
extern AnalogIn    AD3;
extern AnalogIn    AD4;

extern DigitalOut  OUT0;
extern DigitalIn IN0;
extern DigitalOut  OUT1;
extern DigitalIn IN1;
extern DigitalOut  OUT2;
extern DigitalIn IN2;
extern DigitalOut  OUT3;
extern DigitalIn IN3;
extern DigitalOut  OUT4;
extern DigitalIn IN4;
extern DigitalOut  OUT5;
extern DigitalIn IN5;

extern QEI         ENC0;
extern QEI         ENC1;
extern QEI         ENC2;
extern QEI         ENC3;

extern Serial      pc;

extern I2C         i2c0;

extern DigitalIn   SW0;
extern DigitalIn   SW1;

extern DigitalOut  rled;
extern DigitalOut  gled;
extern DigitalOut  bled;



extern void InitBoard();
extern void AdjustCycle(int t_us);
extern int Limit(int value,int max,int min);
extern double Limit_d(double value,double max,double min);



#endif /* INIT_H_ */