#ifndef INCLDUED_SBDBT_h_
#define INCLDUED_SBDBT_h_
#include "mbed.h"

//data[1]
#define SHIKAKU_    0x01
#define L1_         0x02
#define L2_         0x04
#define L3_         0x08
#define R1_         0x10
#define R2_         0x20
#define R3_         0x40

//data[2]
#define UE_         0x01
#define SITA_       0x02
#define MIGI_       0x04
#define HIDARI_     0x08
#define SANKAKU_    0x10
#define BATU_       0x20
#define MARU_       0x40
#define START_      3
#define SELECT_     12

/** 
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "SBDBT.h"
 *
 * // sbdbt pins: PA_0 = Tx, PA_1 = Rx,9600 = baud
 * SBDBT sbdbt(PA_0,PA_1,9600);
 * DigitalOut LED(LED1);//LED
 *
 * int main() {
     while(1){
 *     sbdbt.print();
 *     if(sbdbt.CIRCLE)LED = 1;
 *   }
 * }
 * @endcode
 */
 
class SBDBT
{
private:
    char i;
    char length;
    char value;
    char position;
    char *tmp;
    Serial *sr;

public:
    char readable;
    char *data;
    char *data_p;
    /** Create an SBDBT object connected to the specified UART pins.
     *
     * @param Tx  
     * @param Rx 
     */
    SBDBT(PinName, PinName);
     /** Create an SBDBT object connected to the specified UART pins.
     *
     * @param Tx  
     * @param Rx 
     * @param baud Set serial port baud rate
     */
    SBDBT(PinName, PinName, int baud);
    void getf();
    void print();
    int8_t State_check();
    void check();
    char CIRCLE;
    char CROSS;
    char SQUARE;
    char TRIANGLE;
    char L1;
    char L2;
    char L3;
    char R1;
    char R2;
    char R3;
    char UPkey;
    char DOWNkey;
    char RIGHTkey;
    char LEFTkey;
    char START;
    char SELECT;
    signed char RX;
    signed char RY;
    signed char LX;
    signed char LY;
    char rs_x_check();
    char rs_y_check();
    char ls_x_check();
    char ls_y_check();
    ~SBDBT();
};


#endif