#include "mbed.h"
#include "can.h"

/* PCへのプリント用 */
Serial              pc(USBTX, USBRX);

/* CAN宣言 */
YKNCT_MD_CAN MD(PA_11,PA_12,500000);//(rd , td, 周波数, 送信割り込み速度)

/* ----------------メイン----------------------- */
int main(void)
{
    /* プリントのボーレート設定 */
    pc.baud(115200);

    /* MD初期化 */
    MD.Init(0,MD_SMB);
    MD.Init(1,MD_LAP);
    MD.Init(2,MD_SMB);
    MD.Init(3,MD_LAP);
    MD.Init(4,MD_SMB);
    MD.Init(5,MD_LAP);
    MD.Init(6,MD_SMB);
    MD.Init(7,MD_LAP);


    while(1) {
        /* MD実行 */
        MD.Set(0,100);
        MD.Set(1,100);
        MD.Set(2,100);
        MD.Set(3,0);
        MD.Set(4,0);
        MD.Set(5,50);
        MD.Set(6,0);
        MD.Set(7,50);

        /* エンコーダ取得 */
        for(int i=0; i<8; i++)
            pc.printf("%d  ",MD.Get_enc(i));
        pc.printf("\n\r");

    }
}

