#ifndef INCLUDED_can_h_
#define INCLUDED_can_h_

#include "mbed.h"
#include "CAN.h"
#include "CANMsg.h"
//#include "YKNCT_I2C.h"

/* 定数定義 ------------------------------------------------------------------*/

/* 分解能(最大255まで有効)*/
#define MD_RESOLUTION 100
#define MD_max 10
#define ABS(__VAL__) (((__VAL__) < 0) ? (-(__VAL__)) : (__VAL__))
#define Rest(__val__, __Limit__) ((__val__) >= (__Limit__) ? (__Limit__) : ((__val__) <= (-(__Limit__)) ? (-(__Limit__)) : (__val__)))
#define CAN_TX_ADDRESS 50
#define CAN_RX_ADDRESS 0

typedef enum {
    MD_SMB,
    MD_LAP
} MD_ModeStatus_TypeDef;

typedef enum {
    MD_FREE,
    MD_BRAKE=2
} MD_BrakeStatus_TypeDef;

typedef enum {
    MD_FORWARD,
    MD_REVERSE
} MD_DriveStatus_TypeDef;

/* クラス定義 ----------------------------------------------------------------*/

/*******************************************************************************
 * @名称   YKNCT_MD_I2C
 * @概要   I2Cモジュール"MD"用ライブラリ
*******************************************************************************/
class YKNCT_MD_CAN
{
private:
    /* 出力先の数をカウントする */
    int8_t NumCnt;
    /* 送信データ
      [0] [ MD出力更新 | 0 | 0 | 0 | 0 | ブレーキ | 回転方向 | SMP/RAP ]
      [1] PWM値(7bit)
    */
    int32_t     data[MD_max];

    /* CAN受信用 */
    CANMsg         rxMsg;
    /* CAN送信用 */
    CANMsg         txMsg[MD_max];
    /* 送信割り込み */
    Ticker interrupt;

    int8_t Rx_Id[MD_max];
public:
    CAN can;
    //can.attach(onCanReceived);
    /* I2CのバスのInit */
    YKNCT_MD_CAN(PinName rd, PinName td,int t);
    /* アドレス,モードを設定する */
    void Init(int8_t address, MD_ModeStatus_TypeDef mode);
    /* 出力値を設定する */
    void Set(int8_t ConNumber, int16_t val);
    /* 出力値を設定する(モーター開放あり) */
    void Set(int8_t ConNumber, int16_t val, MD_BrakeStatus_TypeDef option);
    /* 出力値を確認する */
    int16_t  Get_enc(int8_t ConNumber);
    /* 設定された出力値の出力をする */
    void Exe(void);
    /* 割り込み用関数 */
    void sent(void);
    /* 受信用関数 */
    void onCanReceived(void);
};
#endif