//#include "YKNCT_MD.h"
#include "can.h"
#include "mbed.h"
/*******************************************************************************
 * @名称   YKNCT_MD_I2C
 * @概要   I2Cモジュール"MD"用ライブラリ
*******************************************************************************/


/* 送信データ
[0] [| none | none | none | none | none | none |LAP or SMB| |LAP or SMB|]
[1] PWM値1
[2] PWM値2
*/

YKNCT_MD_CAN::YKNCT_MD_CAN(PinName rd, PinName td,int t) : can(rd, td,t)
{
    /* 初期化 */
    NumCnt = 0;
    /* 送信割り込み */
    interrupt.attach_us(this,&YKNCT_MD_CAN::sent,1800);
    /* 受信割り込み */
    can.attach(this,&YKNCT_MD_CAN::onCanReceived);
}
void YKNCT_MD_CAN::Init(int8_t address, MD_ModeStatus_TypeDef mode)
{
    /* アドレス設定 */
    txMsg[NumCnt/2].id = address+CAN_TX_ADDRESS;
    /* モード設定 */
    txMsg[NumCnt/2].data[0] |= mode<<NumCnt%2;
    /* 出力状態初期化 */
    txMsg[NumCnt/2].data[NumCnt%2+1] = 0;
    /* カウンター増やす */
    Rx_Id[NumCnt] = CAN_RX_ADDRESS+NumCnt;
    NumCnt++;
}
void YKNCT_MD_CAN::Set(int8_t ConNumber, int16_t val)
{
    Set(ConNumber, val, MD_BRAKE);
}

void YKNCT_MD_CAN::Set(int8_t ConNumber, int16_t val, MD_BrakeStatus_TypeDef option)
{
    int PWM = 0;
    PWM = abs(val);
    PWM = Rest(PWM,95);

    /*  送るバイト数設定  */
    txMsg[ConNumber/2].len=3;

    /*  idを設定  */
    txMsg[ConNumber/2].id = ConNumber/2+CAN_TX_ADDRESS;

    /*  マイナスならフラグ立てる  */
    if(val<0)
        txMsg[ConNumber/2].data[ConNumber%2+1] |= (1<<7);

    /*   データセット　　PWMを各配列に代入  */
    txMsg[ConNumber/2].data[ConNumber%2+1] |=(char) PWM;
}

int16_t YKNCT_MD_CAN::Get_enc(int8_t ConNumber)
{

    return (int)(double)(data[ConNumber]);
}

void YKNCT_MD_CAN::Exe(void)
{
    static int Scnt=0;
    /*  送信  */
    can.write(txMsg[Scnt]);
    Scnt++;
    Scnt%=NumCnt;
}

void YKNCT_MD_CAN::onCanReceived(void)
{
    static int cnt=0;
    can.read(rxMsg);
    for(int i=0; i<NumCnt; i++) {
        if (rxMsg.id == Rx_Id[i]) {
            /*  エンコーダのデータ受信  一つの基板に付き二つ受信*/
            data[cnt]=(int)((rxMsg.data[2]<<4|rxMsg.data[1]>>4)&0x0fff);
            data[cnt+1]=(int)((rxMsg.data[1]<<8|rxMsg.data[0])&0x0fff);
        }
        cnt+=2;
    }
    cnt=0;
}

void YKNCT_MD_CAN::sent(void)
{
    Exe();
}