#ifndef CANMSG_H
#define CANMSG_H

#include "CAN.h"

class CANMsg : public mbed::CANMessage
{
public:
    /** Creates empty CAN message.
     */
    CANMsg() :
        CANMessage() { }

    /** Creates CAN message with specific content.
     */
    CANMsg(int _id, const char *_data, char _len = 8, CANType _type = CANData, CANFormat _format = CANStandard) :
        CANMessage(_id, _data, _len, _type, _format) { }

    /** Creates CAN remote message.
     */
    CANMsg(int _id, CANFormat _format = CANStandard) :
        CANMessage(_id, _format) { }

    /** Clears CAN message content
     */
    void clear(void)
    {
        len    = 0;
        type   = CANData;
        format = CANStandard;
        id     = 0;
        memset(data, 0, 8);
    };

};

#endif // CANMSG_H
