#include "mbed.h"
#include "C12832.h"
/*
DigitalOut Led1(LED1, 0);
DigitalOut Led2(LED2, 0);
DigitalOut Led3(LED3, 0);
DigitalOut Led4(LED4, 0);
*/
InterruptIn  SW1(p14);
/*
InterruptIn  SW2(p15); 
InterruptIn  SW3(p12); 
InterruptIn  SW4(p16); 
*/

Timer T1;

//************* BusOut ******************
//BusOut Leds (LED1, LED2, LED3, LED4);

//************** LCD ****************

C12832 lcd(p5, p7, p6, p8, p11);

//************* VARIABLEN ****************

enum State {ST_EIN=0, ST_AUS, ST_STOP};
State state;

int LedWert = 3, btnCount = 0;

bool pressed = false;


//*********** KLASSEN ***************

class IsA : BusOut{
    
    public:
    IsA():BusOut(LED1, LED2, LED3, LED4){};
    
    void LedOff(){write(0);}
    
    void LedOn(){write(15);}
    void LedOn(int wert){write(wert);}
    
    
    };

//**********LEDS Klasseninstanz ***********

IsA *Leds = new IsA();

//************* EREIGNISSE ****************
 
void rise(void)
{  
    wait_ms(50);
    pressed = true;
}

bool CheckFlag() 
{
    if (pressed) {
        pressed=false;
        return true;
        }
    return false;
}

//************* STATES ****************

void ST_Ein (void)
{
    //Status auf LCD und Serial
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 1 (EIN)");
    printf("State: 1 (EIN)");
    // entry
    
    // do
    while(true) {
        Leds->LedOn(LedWert);
    
        if(CheckFlag()) {
            btnCount++;
            if(btnCount >= 3){
                btnCount = 0;
                LedWert++;
                state = ST_AUS;
            
    // exit
                return;
            }
        }
    }
}

void ST_Aus (void)
{
    //Status auf LCD und Serial
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 2 (AUS)");
    printf("State: 2 (AUS)");
    
    // entry
    
    // do
    while(true) {
        Leds->LedOff();
    
        if(CheckFlag()) {
            T1.reset();
            T1.start();   // start des Timers für den Doppelklick
             while(1){
                 
                 if(T1.read() >= 0.2) { //Warten für zweiten Klick (Doppelklick)
                        break;                        
                     }
                 
                 else if(CheckFlag()){
                     T1.stop();
                     state = ST_STOP;
                     return;
                     }
             }
            
            state = ST_EIN;

    // exit
            T1.stop();
            return;
            }
        }
}

void ST_Stop (void)
{
    //Status auf LCD und Serial
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: Stop");
    printf("State: Stop");
    wait_ms(200);
    return;
}


void ST_Error (void)
{
    //Status auf LCD und Serial
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: ERROR!!!");
    printf("State: ERROR!!!");
    wait_ms(200);
    return;
}

void stateMachine()
{
    switch (state)
    {
    case ST_EIN: ST_Ein();
        break;
    case ST_AUS: ST_Aus();
        break;
    case ST_STOP: ST_Stop();
        break;
    default: ST_Error();  // sollte nicht auftreten :-)
        break;
    }
}


//************ MAIN ****************
 
int main()
{
    SW1.rise(&rise);      //.fall(&fall);
    
    Leds->LedOn();
    wait_ms(500);
    
    state = ST_EIN;
    while(true){
        stateMachine(); 
        }
}