#include "mbed.h"
 
DigitalOut led(LED1);
InterruptIn btn(p15);
 
Semaphore updates(1);
 
void fall_handler() {
    // release the semaphore
    updates.release();
}
 
int main() {
    btn.fall(&fall_handler);  // The 'fall' handler will execute in IRQ context
    printf("Starting in context %p\r\n", Thread::gettid());
    
    while(1){
            int32_t v = updates.wait(); // wait for the semaphore to be released from the ISR
 
            if (v == 1) {     // now this runs on the main thread, and is safe
                led = !led;
                printf("fall_handler in context %p\r\n",Thread::gettid());
            }
        
        }
    
    
    wait(osWaitForever);
}
