#include "mbed.h"
#include "MLX90620.h"

extern "C" { 
  void xsprintf (char* buff, const char* fmt, ...);
}

#define BS          0x08                    //ascii backspace
#define CR          0x0d                    //ascii CR
#define LF          0x0a                    //ascii LF
#define SP          0x20                    //ascii space
#define ESC         0x1b                    //ascii escape
#define DP          0x2e                    //ascii decimal point / period
#define ticC        0x03                    //ascii control C
#define ticX        0x18                    //ascii control X

extern "C" void mbed_reset();
int revision = 102;
int gDebug = 2;

//RawSerial pc (USBTX, USBRX);
Serial pc(USBTX, USBRX);
//UART1 PIO0_0  PIO0_4
//UART2 PIO0_1/USBRX  PIO0_6/USBTX

//I2C i2c1(P0_10, P0_11);
MLX90620 mlx(P0_10, P0_11, "mlx");            //MLX90620 register access

//RN-42 Reset
DigitalOut p1(P0_8);

//MLX90620 buffers used by MLX90620.cpp
char* EEbuf = new char[256];
char* RamCmmd = new char[8];                //holds / sends MLX90620 RAM commands
char* RamBuf = new char[128];               //0x3f words, values are 'unsigned short'

//For MLX90620
unsigned short ConfigReg = 0;               //MLX90620 configuration register
float Ta = 0.0;
double TempPxl = 0;

//Used for display of temperature and extreme values
int pixX = 0;                               //display pixel X (0-15)
int pixY = 0;                               //display pixel Y (0-3)

//Display Options
int TempC = 'C';                            //***USED BY .INI FILE  display temperatures in degrees C or F

//--------------------------------------------------------------------------------------------------------------------------------------//
//Detect I2C device chain

int i2cQty = 16;                            //number of bytes to get
char i2cData[32];                           //i2c buffer data

char buf[256];

//--------------------------------------------------------------------------------------------------------------------------------------//
// Display on PC using VT100 escape codes
int loop = 0;
bool GotAmbient = false;
bool ReFrame = false;                       //do a reframe if asked

int ShowTempsColor()
{
    ConfigReg = mlx.GetConfigReg();
    if(GotAmbient == false) {
        if((ConfigReg & 0x0100) == 0) {
            Ta = mlx.GetDieTemp();
            GotAmbient = true;
        } else {
            return(ConfigReg & 0x0100);
        }
    }
    if((ConfigReg & 0x0200) == 0) {
        loop++;
        GotAmbient = false;
        if(ReFrame == true) {
            ReFrame = false;
        }
        mlx.LoadMLXRam();
        mlx.StartMeasurement();
    }
    return(0);
}

void ShowTempsVT100()
{
    double HoldTemp = TempPxl;
    pc.puts("st\r\n");
    for(pixY = 0; pixY <= 3; pixY++) {
        for(pixX = 0; pixX < 64; pixX = pixX + 4) {
            TempPxl = mlx.CalcPixel(pixX + pixY);
            if ((TempC == 'c') || (TempC == 'C')) {
                HoldTemp = TempPxl;
            } else {
                HoldTemp = TempPxl * 9.0 / 5.0 + 32.0;
            }

//            if(HoldTemp >= 100.0) {
//                pc.printf(" %.1f  ", HoldTemp);
//            } else if((HoldTemp <= 10.0) && (HoldTemp >= 0.0)) {
//                pc.printf("  %.2f  ", HoldTemp);
//            } else if((HoldTemp >= -10.0) && (HoldTemp < 0.0)) {
//                pc.printf(" %.2f  ", HoldTemp);
//            } else if(HoldTemp < -10.0) {
//                pc.printf("%.2f  ", HoldTemp);
//            } else {
//                pc.printf(" %.2f  ", HoldTemp);
//            }
            int temp = HoldTemp * 100;
            xsprintf(buf, "%d\r\n", temp);
            pc.puts(buf);
            xsprintf(buf, "info x:%d  y:%d  %d\r\n", pixX, pixY, temp);
            pc.puts(buf);
        }
//        pc.printf("\r\n", ESC, pixY);
    }
    pc.puts("ex\r\n");
}

//--------------------------------------------------------------------------------------------------------------------------------------//
// Display Pixels in color

//--------------------------------------------------------------------------------------------------------------------------------------//

int main(void)
{
    // RN-42
    p1 = 0;
    wait_ms(300);

    LPC_SYSCON->BODCTRL |= 2;
    LPC_SYSCON->PDRUNCFG &= (0<<3);

    p1 = 1;
    wait_ms(100);
    pc.baud(115200);

    int initFail = 0;
    //load up eeprom into buffer
    if((mlx.LoadEEPROM())) {
        pc.puts("err e1\r\n");
        initFail++;
    }

    for(pixY = 0; pixY <= 3; pixY++) {
        for(pixX = 0; pixX < 64; pixX = pixX + 4) {
            int Pixel = pixY + pixX;
            if (EEbuf[Pixel + 0x80] < 100) {
                EEbuf[Pixel + 0x80] = 100;
            }
        }
    }

    //Init MLX90620
    unsigned short x = 0;
    if((mlx.SetOscTrimReg())) {
        pc.puts("er e2\r\n");
        initFail++;
    } else {
        x = mlx.GetOscTrimReg();
        xsprintf(buf, "info Osc:  0x%04x\r\n", x);
        pc.puts(buf);
    }

    if((mlx.SetConfigReg())) {
        pc.puts("err e3\r\n");
        initFail++;
    } else {
        x = mlx.GetConfigReg();
        xsprintf(buf, "info Config: 0x%04x\r\n", x);
        pc.puts(buf);
        x = mlx.GetPTATReg();
        xsprintf(buf, "info PTAT:   0x%04x\r\n", x);
        pc.puts(buf);
    }

    if((mlx.StartMeasurement())) {
        pc.puts("err e4\r\n");
        initFail++;
    }
    wait_ms(300);

    if(initFail == 0) {
        mlx.CalcTa_To();
        Ta = mlx.GetDieTemp();
        xsprintf(buf, "info Ta = %f\n\n", Ta);
        pc.puts(buf);
    } else {
        pc.puts("err e5\r\n");
    }
    ShowTempsColor();

    while (true) {
        if(!(ShowTempsColor())) {
            do {
                wait_ms(1);
            } while(ShowTempsColor() != 0);
        }
        
        for(pixY = 0; pixY <= 3; pixY++) {
            for(pixX = 0; pixX < 64; pixX = pixX + 4) {
                int Pixel = pixY + pixX;
                short VirPixelX = (RamBuf[Pixel * 2 + 1] << 8) + RamBuf[Pixel * 2];
                xsprintf(buf, "info x:%d  y:%d  ea:%d  eb:%d  ed:%d  ra:%d\r\n", pixX, pixY, EEbuf[Pixel], EEbuf[Pixel + 0x40], EEbuf[Pixel + 0x80], VirPixelX);
                pc.puts(buf);
            }
        }

        ShowTempsVT100();
        wait_ms(300);
    }
}
