#ifndef AQM0802A_H
#define AQM0802A_H
 
#include "mbed.h"

/**
 * A library for AQM0802A I2C connecting LCD.
 */
class KuAQM0802A : public Stream {
private:
    I2C &i2c;

public:
 
    /**
     * Constractor of AQM0802A driver. 
     * @param i2c I2C object
     */
    explicit KuAQM0802A(I2C &i2c);
 
    /**
     * Destractor
     */
    ~KuAQM0802A();
 
    /**
     * Reset target device
     */
    void reset();

    /**
     * Locate cursor
     * @param x Position X
     * @param y Position Y
     */
    void locate(unsigned int x, unsigned int y);

    /**
     * Print a character
     * @param character A character to print
     */
    void print_char(const int character);

    /**
     * Change LCD contrast
     * @param contrast LCD contrast (0-63)
     */
    void set_contrast(unsigned int contrast);

    // for Stream implementation
    virtual int _putc(int value) { print_char(value); return 1; };
    virtual int _getc() { return -1; };
    
private:
    void send_cmd(char cmd);

    void send(bool CO, bool RS, char code);
};
 
#endif