#include "KuAQM0802A.h"

const int KU_AQM0802A_I2C_ADDR = 0x3E << 1; // 0x7C
const int KU_AQM0802A_INITIAL_CONTRAST = 35;

KuAQM0802A::KuAQM0802A(I2C &i2c_) : i2c(i2c_)
{
    reset();
}

KuAQM0802A::~KuAQM0802A()
{
}

/**
 * Reset AQM0802A LCD
 */
void KuAQM0802A::reset() {
    // wait 40 msec
    wait(0.04);
    // Function set (to Normal Mode)
    send_cmd(0x38);
    // Function set (to Extention Mode)
    send_cmd(0x39);
    // EntryMode (Left to Right, No Shift)
    send_cmd(0x04);
    // Interval OSC frequency
    send_cmd(0x14);
    // Contrast (Low bits)
    send_cmd(0x70 | (KU_AQM0802A_INITIAL_CONTRAST & 0xF));
    // Icon on (0x08) / Booster circuit on (0x04) / Contrast (High bits)
    send_cmd(0x50 | 0x08 | 0x04 | ((KU_AQM0802A_INITIAL_CONTRAST >> 4) & 0x3));
    // Follower control
    send_cmd(0x6C);
    wait(0.2);
    // Function set (to Normal Mode)
    send_cmd(0x38);
    // Display On
    send_cmd(0x0C);
    // Clear Display
    send_cmd(0x01);
    wait(0.2);
}

/**
 * Locate cursor
 */
void KuAQM0802A::locate(unsigned int x, unsigned int y) {
  send_cmd(0x80 | (y * 0x40 + x));
}

/**
 * Print a character
 */
void KuAQM0802A::print_char(const int character) {
    send(false, true, character);
}

/**
 * Change LCD contrast (0-63)
 */
void KuAQM0802A::set_contrast(unsigned int c) {
  send_cmd(0x39);
  send_cmd(0x70 | (c & 0xF));                      // Contrast Set (Low bits)
  send_cmd(0x50 | 0x08 | 0x40 | ((c >> 4) & 0x3)); // Icon on / Booster circuit on / Contrast Set (High bits)
  send_cmd(0x38);
}

/**
 * Send an AQM0802A command
 */
void KuAQM0802A::send_cmd(char cmd) {
    send(false, false, cmd);
}

/**
 * Send raw code.
 */
void KuAQM0802A::send(bool CO, bool RS, char code) {
    char data[2];
    char CObit = CO ? 0x80 : 0x00;
    char RSbit = RS ? 0x40 : 0x00;
    data[0] = CObit | RSbit;
    data[1] = code;
    i2c.write(KU_AQM0802A_I2C_ADDR, data, 2);
}
