#ifndef KU_ADT7410_H
#define KU_ADT7410_H
 
#include "mbed.h"

/**
 * A library for ADT7410 I2C connecting temperature sensor module.
 */
class KuADT7410 {
private:
    I2C &i2c;
    int i2c_address;

public:
 
    /**
     * Constractor of ADT7410 driver. 
     * @param i2c I2C object
     * @param i2c_address Target's I2C address (LSB is used for R/W flag).
     */
    explicit KuADT7410(I2C &i2c, int i2c_address = 0x48 << 1);
 
    /**
     * Destractor
     */
    ~KuADT7410();
 
    /**
     * Reset target device.
     */
    void reset();

    /**
     * Get temperature
     */
    float get_temp();

    /**
     * Get status
     */
    unsigned char get_status();
};
 
#endif