#include "KuADT7410.h"

const int KU_ADT7410_TEMP_REG_ADDR = 0x00;
const int KU_ADT7410_STATUS_REG_ADDR = 0x02;
const int KU_ADT7410_CONFIG_REG_ADDR = 0x03;
const int KU_ADT7410_RESET_REG_ADDR = 0x2F;

KuADT7410::KuADT7410(I2C &i2c_, int i2c_address_) : i2c(i2c_), i2c_address(i2c_address_)
{
    reset();
}

KuADT7410::~KuADT7410()
{
}

float KuADT7410::get_temp() {
    char wdata[1] = {KU_ADT7410_TEMP_REG_ADDR};
    i2c.write(i2c_address, wdata, 1);
    char rdata[2] = {0,0};
    i2c.read(i2c_address, rdata, 2);
    int16_t temp_raw = (rdata[0] << 8) | rdata[1];
    temp_raw /= 8;
    return temp_raw / 16.0f;
}

unsigned char KuADT7410::get_status() {
    char wdata[1] = {KU_ADT7410_STATUS_REG_ADDR};
    i2c.write(i2c_address, wdata, 1);
    char rdata[1] = {0};
    i2c.read(i2c_address, rdata, 1);
    return rdata[0];
}

void KuADT7410::reset()
{
    char data[1] = {KU_ADT7410_RESET_REG_ADDR};
    i2c.write(i2c_address, data, 1);
    wait(0.25);
}