#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

DigitalOut myled(LED1);
AnalogIn light_in(p20);
AnalogIn temp_in(p19);
AnalogIn humid_in(p18);
 
int main()
{
    const char apikey[] = "xxxxxxxxxxxxxxxxxxxxxxx"; // your apikey
    const char feed[]= "/feeds/00000"; // //your feed URL
    char cms[512];
    char recv[512];
    int token = 0;
    EthernetInterface eth;
    eth.init();
    eth.connect();
    wait(5);
    printf("IP Address is %s\n\r", eth.getIPAddress());
    
    while (1) {
    Websocket ws("ws://api.cosm.com:8080/feeds/");
    ws.connect();
    if(ws.read(recv)) {
        printf("rcv: %s\r\n", recv);
    }
   
    float r_light, r_temp, r_humid;
    float light, temp, humid;
    
    light = light_in;
    temp = temp_in;
    humid = humid_in;
    
    r_light = light * 3.3 * 5 / 0.013;
    r_temp = temp * 3.3 * 100 - 60;
    r_humid = humid * 3.3 * 100;

    myled = 1;
    sprintf (cms,"{\"method\" : \"put\",\"resource\" : \"%s\",\"params\" : {},\"headers\" : {\"X-ApiKey\":\"%s\"},\"body\" :{\"version\" : \"1.0.0\",\"datastreams\" : [{\"id\" : \"0\",\"current_value\" : \"%4.0f\"},{\"id\" : \"1\",\"current_value\" : \"%3.0f\"},{\"id\" : \"2\",\"current_value\" : \"%3.0f\"}]},\"token\" : \"0x%d\"}\r\n",feed,apikey,r_light,r_temp,r_humid,token);
    //set your ID and value
    printf ("%s\r\n",cms);
    token++;
    int res = ws.send(cms);
    myled= 0 ;
    wait(5);
 
 
    if(ws.read(recv)) {
        printf("rcv: %s\r\n", recv);
        wait(1);
    }
        
    ws.close();
    wait(300);
 
    }
}