#include "mbed.h"
#include "TextLCD.h"
#include "SCP1000.h"
#include "EthernetInterface.h"
#include "Websocket.h"

DigitalOut myled(LED1);
TextLCD lcd(p24, p25, p26, p27, p28, p29, p30);;
AnalogIn light_in(p20);
AnalogIn temp_in(p19);
AnalogIn humid_in(p18);
SCP1000 scp1000(p11,p12,p13,p14);

void splash();
void splash()
{

    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("ku-make sensor");
    lcd.locate(0, 1);
    lcd.printf("@kumajoi");
    wait(0.3);
}

int main()
{
    splash();

    const char apikey[] = "xxxxxxxxxxxxxxxxxxxxxx"; //Change your apikey
    const char feed[]= "/feeds/00000";  //Change your feed URL
    char cms[512];
    char recv[512];
    int token = 0;
    EthernetInterface eth;
    eth.init();
    eth.connect();
    wait(5);
    lcd.cls();
    printf("IP Address is %s\n\r", eth.getIPAddress());
    lcd.printf("IP Address is %s\n\r", eth.getIPAddress());

    while (1) {
        Websocket ws("ws://api.cosm.com:8080/feeds/");
        ws.connect();
        if(ws.read(recv)) {
            printf("rcv: %s\r\n", recv);
        }

        float r_light, r_temp, r_humid, r_hpa;
        float light, temp, humid, hpa;

        light = light_in;
        temp = temp_in;
        humid = humid_in;
        hpa = scp1000.readPressure();
        
        // If you want, please change the value.
        r_light = light * 3.3 * 5 / 0.013;
        r_temp = temp * 3.3 * 100 - 60;
        r_humid = humid * 3.3 * 100;
        r_hpa = hpa / 100;


        lcd.cls();
        lcd.locate(0, 0);
        lcd.putc(0xB5);
        lcd.putc(0xDD);
        lcd.putc(0xC4);
        lcd.putc(0xDE);
        lcd.printf("%2.0f",r_temp);
        lcd.putc(0xDf);
        lcd.putc('C');
        lcd.printf(" %4.0fhPa", r_hpa);
        lcd.locate(0, 1);
        lcd.putc(0xBC);
        lcd.putc(0xC2);
        lcd.putc(0xC4);
        lcd.putc(0xDE);
        lcd.printf("%2.0f%% ",r_humid);
        lcd.locate(9, 1);
        lcd.printf("%4.0f", r_light);
        lcd.putc(0xD9);
        lcd.putc(0xB8);
        lcd.putc(0xBD);

        myled = 1;
        // If you want, change the ID, Number of digits.
        sprintf (cms,"{\"method\" : \"put\",\"resource\" : \"%s\",\"params\" : {},\"headers\" : {\"X-ApiKey\":\"%s\"},\"body\" :{\"version\" : \"1.0.0\",\"datastreams\" : [{\"id\" : \"0\",\"current_value\" : \"%4.0f\"},{\"id\" : \"1\",\"current_value\" : \"%3.0f\"},{\"id\" : \"2\",\"current_value\" : \"%3.0f\"},{\"id\" : \"3\",\"current_value\" : \"%4.0f\"}]},\"token\" : \"0x%d\"}\r\n",feed,apikey,r_light,r_temp,r_humid,r_hpa,token);
 
        printf ("%s\r\n",cms);
        token++;
        int res = ws.send(cms);
        myled= 0 ;
        wait(5);

        if(ws.read(recv)) {
            printf("rcv: %s\r\n", recv);
            wait(1);
        }

        ws.close();
        // If you want, change the Interval.
        wait(300);

    }
}