/*
* This library is tested with Wiznet W7500 and Max7219 Chip to interface the LED Dot Matrix
* We tested with 4 cascaded Max7219 chip.
* The connections are as follow:

        W7500            Max7219
            
         MOSI (PA_08)   -> Din
         MISO           -> NC
         SCK  (PA_06)   -> CLK
         D8(Digital Pin)-> CS
         Vcc            -> Vcc
         Gnd            -> Gnd
            

*To send any string greater than 4 words, it has to be declared in the scope (ex given below- char Hello[])
*The link given below helps in creating the particular word/string the user wants to display.
* link - https://xantorohara.github.io/led-matrix-editor/#a2a2a2bea2a2a2a2|df40405f5f40405f|f710101010101010|7984848484848478

*/


/* Example program
*#include "max7219.h"
*max7219 m; 

//Defining hex code for "HELLO"
*char Hello[]={0xa2,0xa2,0xa2,0xbe,0xa2,0xa2,0xa2,0xa2,
*           0xdf,0x40,0x40,0x5f,0x5f,0x40,0x40,0x5f,
*            0xf7,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
*            0x79,0x84,0x84,0x84,0x84,0x84,0x84,0x78};      
*int main() {
*    m.init();
*    while(1){
      //To send 4 or less letters or digits, use the send fuction 
*       m.send("123"); 
*       wait(0.5); //Delay

*        m.send("AbCd");
*        wait(0.5);

        //To send any word/string use the send string function
*        m.sendstring(Hello);
*        wait(0.5);

*            }
*}

*/
#ifndef MAX7219_H
#define MAX7219_H

#include "mbed.h"

#define max7219_reg_noop         0x00
#define max7219_reg_digit0       0x01
#define max7219_reg_digit1       0x02
#define max7219_reg_digit2       0x03
#define max7219_reg_digit3       0x04
#define max7219_reg_digit4       0x05
#define max7219_reg_digit5       0x06
#define max7219_reg_digit6       0x07
#define max7219_reg_digit7       0x08



class max7219
{
public: 

max7219(); // PA_08, NC, PA_06, digital_pin

~max7219();    
void init();

void send(char*); 

void sendstring(char*);

private:
PinName mosi;
PinName miso;
PinName sclk;
PinName load;   
};

#endif