//Author: Kuldip Maharjan
//Email : kuldipmaharjan@gmail.com
//Anyone can use this code if it helps in their projects or
//for learning programing in mbed besides for commercial purposes


//This is the main software for smart mug project that I wrote for my senior design
//It includes utilization of different components of mbed board
//Other important components used by this code
//-Serial Miniature LCD Module (uLCD-144-G2 GFX)
//-micro-sd card stored inside LCD module
//-tilt sensor
//-CLC level sensor
//-temperature sensor
//-three input buttons
//-battery fuel gauge(very difficult to configure)

//I don't expect people to understand everything in this code but I am sure
//someone can utilize some parts of it to understand mbed platform better

#include "mbed.h"               //loads the main library for mbed board
#include "string.h"             //loads library to control strings


// for testing
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


//DigitalOut lcd_reset(p19);     // used to reset the lcd
I2C    i2c( p28, p27 );          // sda, scl for fuel gauge
AnalogIn temperature(p20);       // for temp sensor input
AnalogIn tiltsensor(p19);        // for clc sensor input
AnalogIn clcLevelSensor(p18);    // for clc sensor input

//Serial pc(USBTX, USBRX);         // tx, rx if wire used pc terminal
Serial pc(p9, p10);              // tx, rx
Serial lcd(p13,p14);             // tx, rx for lcd connection


//setting up interrupt buttons
InterruptIn up_button(p5);
InterruptIn down_button(p6);
InterruptIn ok_button(p7);

/*======================================global functions=====================================================*/
void button_onrise_function_link();                                         //for interrupt buttons

void auto_baud();                                                           //sets baud of lcd to that of the arm
void clear_screen();                                                        //clears the screen of lcd
void set_font();                                                            //sets font size
void set_color();                                                           //sets background color
void lcd_reset_function();                                                  //used to reset lcd
void display_image(int menu_num);                                           //displays menu picture in the lcd
void display_string(int row, int col, char* str,int color1,int color2);     //displays string on lcd

void loadLiquidList();                                                      //load the 10 liquid list
void display_liquid_list(int track);                                        // display liquid list and keep track of the choosen one
void initial_setup();                                                       //the main screen

void readTemperature();                                                     //reads the temperature
void readLiquidLevel();                                                     //reads liquid level in the MUG
void read_time_date();                                                      //reads the current time and date

void readVolumeChange(float volume);


void get_database();                                                        //sync the new liquid database when 'D' is sent from the GUI
void send_userdata();                                                       //send liquidname, amount, and time info
void save_drink_animation();



void readDatabase();                                                        //load name and calorie from the memory card
void writeDatabase();                                                       //write name and calorie into memory card
void writeByte(char a);                                                     //for writing byte to memory


void set_address(int hex1, int hex2, int hex3, int hex4);                   //for setting address pointer to read or write data on memory card
void write_byte(char a);                                                    //writes a byte into the memory card
void read_byte();                                                           //reads a byte but not currently used!!!!!
void write_name_to_memory();                                                //write the whole liquid data to the memory
void read_name_from_memory();                                               //read the liquid data from the memory to the array

void write_user_counters();                      //for writing three counter values
void read_user_counters();                       // for reading three counter values
void read_user_history();                        // for reading user history
void write_user_history();                       // for writing user history


void interrupt_condition_handler(int button);                               //handles the logics after interrupt
void drink_session_handler();                                               //handles drinking session
void level_sensor_handler();                                                //handles the task of reading values from level sensor
void download_handler();                                                    //handles the download of 10 liquids
void read_temperature();                                                    //for reading temperature


/*==============================================global variables===============================================*/
int current_state=0;                //0=first display, 1=menu page, 2=liquid page
int inside_if_tracker=1;
int current_liquid_index=1;         //keeps track of current liquid
int drink_session_on =0;            //lets us know if drinking session is going on which is state 2
int drink_session_off_signal =0;    //used to limit interrupt problems
int counter_for_display=0;          //used to limit the refresh rate of session
char current_temperature[10]="";    //stores current temperature
char current_date[16]="";           //stores date after we call the function
char current_time[16]="";           //stores time after we call the function

double max_level=0.7;               //stores the max output of the level sensor
double min_level=0.2;               //stores the min output of the level sensor
double scale_to_register=0;         //this scale is used as a threshold to know when to count the level as increased or decreased
double current_level=0;             //stores the current level of liquid
double previous_level=0;            //stores the previous level of liquid so that we cand decide it liquid increased or decreased
double consumed_level=0;            //stores the amount of drink that the user consumed in a session

char data_counter=48;               //this will keep track of the user data
char data_cursor=48;                //this keeps track of which value to read
char synced_GUI_counter=48;         //this will keep track of the synced GUI data
char synced_app_counter=48;         //this will keep track of the synced app data
char current_history[50];           //stores the current history

char temp_string[50];               //whenever there is need to print temporary string
bool hand_shake  = false;
int countEntry=1;

char liquid[15][25];                //handles liquid name
char calorie[15][5];                //handles calorie data



/*
char name1[20] = "juice1";
char name2[20] = "Juice2";
char name3[20] = "Coffee 5";
char name4[20] = "Milk";
char name5[20] = "Pepsi";
char name6[20] = "D. Pepsi";
char name7[20] = "M. Dew";
char name8[20] = "D. M. Dew";
char name9[20] = "Coke";
char name10[20] = "Fanta";
*/

/*=============================================================================================
                                       WHEN UP BUTTON IS PRESSED
===============================================================================================*/
void up_pressed_func()
{
    led1=!led1;

    if (current_state == 1) {
        interrupt_condition_handler(1);
    }

}

/*=============================================================================================
                                       WHEN DOWN BUTTON IS PRESSED
===============================================================================================*/
void down_pressed_func()
{
    led2=!led2;
    if (current_state==1) {
        interrupt_condition_handler(2);
    }
}

/*=============================================================================================
                                     WHEN OK BUTTON IS PRESSED
===============================================================================================*/
void ok_pressed_func()
{
    inside_if_tracker=1;
    led3=!led3;
    if (current_state==1 && inside_if_tracker==1) {
        //go inside the liquid
        current_state=2;
        inside_if_tracker=0;
    } else if (current_state==2 && inside_if_tracker==1) {
        //show first item in liquid list
        current_state=1;
        inside_if_tracker=0;
    }
    interrupt_condition_handler(3);
}


int main()
{
    initial_setup();


    //read top ten liquids from the databse

    set_time(1366476350);  // http://www.epochconverter.com/
    //display_image(1);
    read_time_date();

    /*  here we load the liquid names into the array
        sprintf(liquid[1],"%s",name1);
        sprintf(liquid[2],"%s",name2);
        sprintf(liquid[3],"%s",name3);
        sprintf(liquid[4],"%s",name4);
        sprintf(liquid[5],"%s",name5);
        sprintf(liquid[6],"%s",name6);
        sprintf(liquid[7],"%s",name7);
        sprintf(liquid[8],"%s",name8);
        sprintf(liquid[9],"%s",name9);
        sprintf(liquid[10],"%s",name10);
    */
    //clear_screen();
    //display_string(5,1, "writing on database",0xFF,0xFF);
    //writeDatabase();
    //clear_screen();
    //display_string(5,1, "writing done" ,0xFF,0xFF);
    //clear_screen();
    //display_string(5,1, "reading from database" ,0xFF,0xFF);

    //readDatabase();
    //clear_screen();
    //display_string(5,1, "read from database done" ,0xFF,0xFF);


    //pc.printf("lskdjflsf");
    //pc.printf("%s readliquid",liquid[2]);
    // clear_screen();
    //display_string(5,1, liquid[3],0xFF,0xFF);
    /*=============================================================================================
                                           THE MAIN LOOP
    ===============================================================================================*/
    while(1) {
        counter_for_display++;
        download_handler();

        if (drink_session_on ==1 && counter_for_display>= 10000000) {
            drink_session_handler();
            //if (drink_session_on == 1) wait(3);             //cause value of drink_session_on can change from interrupt
            if (drink_session_on==0) {
                counter_for_display=0;
                clear_screen();

                save_drink_animation();
                //here we need to save the new data in the memory

                sprintf(current_history,"%s,%s,%s,%0.2f,%s",current_date, current_time,liquid[current_liquid_index],consumed_level,calorie[current_liquid_index]);
                // while (data_counter < 58) {
                write_user_history();
                //     read_user_history();
                //}*/
                clear_screen();
                //resetting the values
                current_level=0;
                previous_level=0;
                consumed_level=0;
                display_string(2,0,"||||||||||||||||",0x00,0x00);
                display_string(4,1,liquid[current_liquid_index],0xFF,0xFF);
                display_string(5,1,calorie[current_liquid_index],0xFF,0xFF);
                display_string(5,4," cal/8 oz",0xFF,0xFF);
                display_string(7,0,"||||||||||||||||",0x00,0x00);
                display_string(9,0," <     ok     > ",0XFF, 0x00);
            }
            counter_for_display=0;
        }


    }//end  main while

}

void initial_setup()
{
    button_onrise_function_link();          //setup interrupt for buttons
    pc.baud(9600);                          // for setting baud rate for cellphone or pc connection
    auto_baud();                            // for setting baud rate for the lcd
    clear_screen();                         // clear the screen in the beginning
    set_font();                             // set font size and stuffs
    set_color();
    display_string(5,1,"Smart Mug v1",0xFF,0xFF);
    readDatabase();
    write_user_counters();
    read_user_counters();

    wait(0.5);
    clear_screen();
    current_state=1;
    display_string(2,0,"||||||||||||||||",0x00,0x00);
    display_string(4,1,liquid[current_liquid_index],0xFF,0xFF);
    display_string(5,1,calorie[current_liquid_index],0xFF,0xFF);
    display_string(5,4," cal/8 oz",0xFF,0xFF);
    display_string(7,0,"||||||||||||||||",0x00,0x00);
    display_string(9,0," <     ok     > ",0XFF, 0x00);
    scale_to_register= (max_level - min_level)/10;
}

/*===========================THE BUTTONS===============================================*/
void button_onrise_function_link()
{
    up_button.rise(&up_pressed_func);
    down_button.rise(&down_pressed_func);
    ok_button.rise(&ok_pressed_func);
}

void interrupt_condition_handler(int button)
{
    if (button == 1) {
        current_liquid_index--;
        if(current_liquid_index <1) current_liquid_index=10;
        clear_screen();
        display_string(2,0,"||||||||||||||||",0x00,0x00);
        display_string(4,1,liquid[current_liquid_index],0xFF,0xFF);
        display_string(5,1,calorie[current_liquid_index],0xFF,0xFF);
        display_string(5,4," cal/8 oz",0xFF,0xFF);
        display_string(7,0,"||||||||||||||||",0x00,0x00);
        display_string(9,0," <     ok     > ",0XFF, 0x00);


    }
    if (button ==2) {
        current_liquid_index++;
        if (current_liquid_index >10) current_liquid_index=1;
        clear_screen();
        display_string(2,0,"||||||||||||||||",0x00,0x00);
        display_string(4,1,liquid[current_liquid_index],0xFF,0xFF);
        display_string(5,1,calorie[current_liquid_index],0xFF,0xFF);
        display_string(5,4," cal/8 oz",0xFF,0xFF);
        display_string(7,0,"||||||||||||||||",0x00,0x00);
        display_string(9,0," <     ok     > ",0XFF, 0x00);
    }

    if (button==3) {
        if ( current_state==1) {
            //clear_screen();
            //display_string(5,1,liquid[current_liquid_index],0xFF,0xFF);
            drink_session_off_signal=1;
            //here we need to save value from the drink sessions
        } else if (current_state==2) {
            drink_session_on=1;
        }
        counter_for_display= 9999999;
    }

}

void drink_session_handler()
{
    char level[5]="";
    if(drink_session_off_signal==0) {
        clear_screen();
        //display_string(4,1,liquid[current_liquid_index],0x00,0x00);
        //display_string(5,1,"remainng liquid",0x00,0x00);
        //display_string(6,1,"current temperature",0x00,0x00);

        display_string(0,0,"----------------", 0xFF,0xFF);
        display_string(1,1,"Drink Session",0xFF,0xFF);
        display_string(2,0,"----------------", 0xFF,0xFF);
        display_string(3,1,liquid[current_liquid_index],0xFF,0xFF);
        display_string(4,1,calorie[current_liquid_index],0xFF,0xFF);
        display_string(4,4," cal/8 oz",0xFF,0xFF);

        level_sensor_handler();
        sprintf(level,"%.2f",current_level);
        display_string(5,1,level,0xFF,0xFF);
        sprintf(level,"%.2f",previous_level);
        display_string(5,6,level,0xFF,0xFF);
        sprintf(level,"%.2f",consumed_level);
        display_string(5,11,level,0xFF,0xFF);


        read_temperature();
        display_string(7,1,current_temperature,0xFF,0xFF);
        read_time_date();
        display_string(8,1,current_time,0xFF,0xFF);
        display_string(9,0,"     -back-     ",0xFF,0xFF);
    }
    if(drink_session_off_signal==1) {
        drink_session_on=0;
        drink_session_off_signal=0;
    }

}


void download_handler()
{
    char options[1];
    if (pc.readable()) {

        if(hand_shake == false) {
            options[0]=pc.getc();
            if(options[0]=='D') {
                // pc.printf("%s\n","got it");
                pc.printf("%s\n","D!");
                hand_shake = true;
                display_string(9,1,"Downloading...",0xFF,0xFF);
            } else if (options[0]=='S') {
                pc.printf("%s\n","S!");
                if (synced_app_counter < data_counter) {

                    for (data_cursor= synced_app_counter; data_cursor<data_counter; data_cursor++) {

                        display_string(0,1,"for loop",0xFF,0xFF);
                        wait(0.5);
                        display_string( 0,1,"for loop",0x00,0x00);
                        read_user_history();
                        pc.printf("%s",temp_string);
                        pc.printf("data_cursor=%c data_counter=%c synced_app_counter%c",data_cursor,data_counter, synced_app_counter);
                        //if (data_cursor+1<data_counter) pc.printf(",");
                    }

                    synced_app_counter=data_cursor;
                    pc.printf("data_cursor=%c data_counter=%c synced_app_counter%c",data_cursor,data_counter, synced_app_counter);
                    write_user_counters();
                    pc.printf("\n");
                } else if (synced_app_counter > data_counter) {
                    data_cursor = synced_app_counter;
                    while( data_cursor < 58) {
                        display_string(0,1,"for loop",0xFF,0xFF);
                        wait(0.5);
                        display_string( 0,1,"for loop",0x00,0x00);
                        read_user_history();
                        pc.printf("%s",temp_string);
                        pc.printf("data_cursor=%c data_counter=%c synced_app_counter%c",data_cursor,data_counter, synced_app_counter);
                        data_cursor++;
                    }
                    if (data_cursor == 58) data_cursor = 48;

                    for (; data_cursor<data_counter; data_cursor++) {

                        display_string(0,1,"for loop",0xFF,0xFF);
                        wait(0.5);
                        display_string( 0,1,"for loop",0x00,0x00);
                        read_user_history();
                        pc.printf("%s",temp_string);
                        pc.printf("data_cursor=%c data_counter=%c synced_app_counter%c",data_cursor,data_counter, synced_app_counter);
                        //if (data_cursor+1<data_counter) pc.printf(",");
                    }

                    synced_app_counter=data_cursor;
                    pc.printf("data_cursor=%c data_counter=%c synced_app_counter%c",data_cursor,data_counter, synced_app_counter);
                    write_user_counters();
                    pc.printf("\n");




                } else if (synced_app_counter == data_counter) {

                    pc.printf("nothing\n");


                }
                //   pc.printf("\n");
                //read_user_history();
                //pc.printf("%s",temp_string);
                //pc.printf(",");
                //pc.printf("%s",temp_string);
                //pc.printf("\n");
                display_string(8,1,"inside upload",0xFF,0xFF);
            } else
                display_string(8,1,"mistake",0xFF,0xFF);

        } else if (hand_shake == true) {
            pc.scanf("%[^\n]s",temp_string);
            //pc.printf("%s\n",buffer);
            char *p;
            p = strtok(temp_string, "#");
            strcpy(liquid[countEntry], p);

            p = strtok(NULL, "#");
            strcpy(calorie[countEntry], p);
            countEntry++;

            if(countEntry >10) {
                hand_shake = false;
                display_string(2,1,"handsake true",0xFF,0xFF);
                countEntry = 1;
                if(liquid[1][0]=='D') {
                    for (int i=0; i<15; i++) {
                        liquid[1][i]=liquid[1][i+1];
                    }

                }
                writeDatabase();
                readDatabase();
                display_string(9,1,"Downloading...",0x70,0xDB);
                pc.printf("%s\n","E!");
                //now update database;
            } else {
                pc.printf("%s\n","D!");

            }
        }
    } else if(1) {
        //pc.printf("\r%s\n","A");
    }


}

void save_drink_animation()
{
    display_string(5,1," saving drink", 0xFF,0xFF);
    display_string(6,1," session", 0xFF, 0xFF);
    //save the values here which will be later sent to the gui and app
    wait(0.2);
    display_string(6,10,".", 0xFF, 0xFF);
    wait(0.2);
    display_string(6,11,".", 0xFF, 0xFF);
    wait (0.2);
    display_string(6,12,".", 0xFF, 0xFF);
    wait (0.2);
}

void writeDatabase()
{
    set_address(0x00,0x00,0x50,0x50);

    //for loop below writes liquid names to the sd card
    for(int i=1; i<=10; i++) {
        for(int j=0; j<=20; j++) {
            writeByte(liquid[i][j]);
        }

    }
    //for loop below writes calories into the sd card
    for(int i=1; i<=10; i++) {
        for(int j=0; j<=5; j++) {
            writeByte(calorie[i][j]);
        }
    }
}


void readDatabase()
{
    set_address(0x00,0x00,0x50,0x50);
    //char g[2];
    for(int i=1; i<=10; i++) {
        for(int j=0; j<=20; j++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            liquid[i][j]=lcd.getc();
            //sprintf(g,"%c",lcd.getc());
            // clear_screen();
            //display_string(10,10,g,0xFF,0xFF);
            //wait(0.01);
        }
    }
    for(int i=1; i<=10; i++) {
        for(int j=0; j<=5; j++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            calorie[i][j]=lcd.getc();
            // sprintf(g,"%c",lcd.getc());
            //clear_screen();
            //display_string(10,10,g,0xFF,0xFF);
            //wait(0.5);
        }
    }

}

void set_address(int hex1, int hex2, int hex3, int hex4)
{
    while (!lcd.writeable()) {}
    lcd.putc(0x40);

    while (!lcd.writeable()) {}
    lcd.putc(0x41);

    while (!lcd.writeable()) {}
    lcd.putc(hex1);

    while (!lcd.writeable()) {}
    lcd.putc(hex2);

    while (!lcd.writeable()) {}
    lcd.putc(hex3);

    while (!lcd.writeable()) {}
    lcd.putc(hex4);

    while (!lcd.readable()) {}
    lcd.getc();
    //pc.printf("\n\rpointer set %x ",lcd.getc());
}



void read_time_date()
{
    time_t seconds = time(NULL);
    //http://mbed.org/handbook/Time?action=view&revision=11592
    //char buffer[32];
    //strftime(date_time, 16, "time:%X date:%m/%d/%y", localtime(&seconds));
    //pc.printf("\r %s \n", buffer);
    strftime(current_time, 16, "%H:%M %p", localtime(&seconds));
    strftime(current_date, 16, "%m/%d/%y", localtime(&seconds));
    //clear_screen();
    //display_string(1,1,buffer,0xE0,0xE0);
}

void writeByte(char a)
{
    while (!lcd.writeable()) {}
    lcd.putc(0x40);

    while (!lcd.writeable()) {}
    lcd.putc(0x77);

    while (!lcd.writeable()) {}
    lcd.putc(a);

    while (!lcd.readable()) {}     //receiving the acknowledgement bit
    lcd.getc();
}

void auto_baud()
{
    while (!lcd.writeable()) {}    //command to set the auto baud
    lcd.putc('U');

    while (!lcd.readable()) {}     //receiving the acknowledgement bit
    while(lcd.getc() != 0x06) lcd.putc('U');
    //pc.printf("\n\rauto baud set");
}

void clear_screen()
{
    while (!lcd.writeable()) {}    //command to clear the screen
    lcd.putc('E');

    while (!lcd.readable()) {}     //receiving the acknowledgement bit
    // pc.printf("\n\rlcd screen cleared");
    // pc.putc(lcd.getc());
    lcd.getc();
}

void display_image(int menu_num)
{
    clear_screen();

    int address=0xC0;
    if (menu_num == 0)address=0x80;
    if (menu_num == 1)address=0xC0;
    if (menu_num == 2)address=0x00;
    if (menu_num == 3)address=0x40;
    pc.printf("%d  %x", menu_num, address);

    while (!lcd.writeable()) {}    //ext_cmd
    lcd.putc('@');
    while (!lcd.writeable()) {}    //command header byte
    lcd.putc(0x49);
    while (!lcd.writeable()) {}    //horizontal start position
    lcd.putc(0x00);
    while (!lcd.writeable()) {}    //vertical start position
    lcd.putc(0x00);
    while (!lcd.writeable()) {}    //width
    lcd.putc(0x80);
    while (!lcd.writeable()) {}    //height
    lcd.putc(0x80);
    while (!lcd.writeable()) {}    //colormode
    lcd.putc(0x10);
    while (!lcd.writeable()) {}    //address
    lcd.putc(0x00);
    while (!lcd.writeable()) {}    //address
    lcd.putc(0x00);
    while (!lcd.writeable()) {}    //address
    lcd.putc(address);
    while (!lcd.readable()) {}     //receiving the acknowledgement bit
    pc.putc(lcd.getc());
}

void display_string(int row, int col, char* str,int color1,int color2)
{
    while (!lcd.writeable()) {}    //string text
    lcd.putc(0x73);
    while (!lcd.writeable()) {}    //col
    lcd.putc(col);
    while (!lcd.writeable()) {}    //row
    lcd.putc(row);
    while (!lcd.writeable()) {}    //5x7 font
    lcd.putc(0x02);
    while (!lcd.writeable()) {}    //color1
    lcd.putc(color1);
    while (!lcd.writeable()) {}    //color2
    lcd.putc(color2);
    while (!lcd.writeable()) {}    //string
    //lcd.putc(0x41);
    lcd.printf("%s",str);
    while (!lcd.writeable()) {}    //terminator
    lcd.putc(0x00);
    while (!lcd.readable()) {}     //receiving the acknowledgement bit
    //pc.putc(lcd.getc());
    lcd.getc();
}

void set_font()
{
    while (!lcd.writeable()) {}    //command to set the font
    lcd.putc(0x46);
    while (!lcd.writeable()) {}    //command to set 5x7 small sized font
    lcd.putc(0x02);
    while (!lcd.readable()) {}     //receiving the acknowledgement bit
    //pc.putc(lcd.getc());
    lcd.getc();
    //pc.printf("\nfont is set");
}

void set_color()
{
    while (!lcd.writeable()) {}    //command to change the background color
    lcd.putc(0x4B);
    while (!lcd.writeable()) {}    //command to set msb for color
    lcd.putc(0x70);
    while (!lcd.writeable()) {}    //command to set lsb for color
    lcd.putc(0xDB);
    lcd.getc();

}

void read_temperature()
{
    sprintf(current_temperature,"%.1f C",temperature.read()*3.3*100);
}


void level_sensor_handler()
{

    /*  to print tilt level
    char tilt[5]="";
    sprintf(tilt,"%.2f",tiltsensor.read());
    display_string(9,0,tilt,0xFF,0xFF);
    */
    if (tiltsensor.read() >0.7) display_string(9,0,"mug tilted",0xFF,0xFF);
    if (tiltsensor.read() < 0.5) {
        current_level=clcLevelSensor.read();
        if (current_level >= previous_level) {      //it means liquid added
            if((current_level - previous_level) > scale_to_register) {
                previous_level=current_level;
            }
        }
        if (current_level<previous_level) {         //it means liquid drank
            if ((previous_level - current_level) > scale_to_register) {
                consumed_level += (previous_level - current_level);
                previous_level=current_level;
            }
        }
    }

}

void write_user_counters()
{
    set_address(0x00,0x50,0x00,0x00);
    writeByte(data_counter);
    writeByte(synced_GUI_counter);
    writeByte(synced_app_counter);
}

void read_user_counters()
{
    set_address(0x00,0x50,0x00,0x00);

    while (!lcd.writeable()) {}
    lcd.putc(0x40);

    while (!lcd.writeable()) {}
    lcd.putc(0x72);

    while (!lcd.readable()) {}     //receiving the acknowledgement bit
    data_counter=lcd.getc();

    while (!lcd.writeable()) {}
    lcd.putc(0x40);

    while (!lcd.writeable()) {}
    lcd.putc(0x72);

    while (!lcd.readable()) {}     //receiving the acknowledgement bit
    synced_GUI_counter=lcd.getc();

    while (!lcd.writeable()) {}
    lcd.putc(0x40);

    while (!lcd.writeable()) {}
    lcd.putc(0x72);

    while (!lcd.readable()) {}     //receiving the acknowledgement bit
    synced_app_counter=lcd.getc();

    //pc.printf("%c %c %c", data_counter, synced_GUI_counter, synced_app_counter);


}
void write_user_history()
{
    if (data_counter == 48) {
        set_address(0x00,0x70,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }
    if (data_counter == 49) {
        set_address(0x00,0x71,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }
    if (data_counter == 50) {
        set_address(0x00,0x72,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }
    if (data_counter == 51) {
        set_address(0x00,0x73,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }
    if (data_counter == 52) {
        set_address(0x00,0x74,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }
    if (data_counter == 53) {
        set_address(0x00,0x75,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }
    if (data_counter == 54) {
        set_address(0x00,0x76,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }
    if (data_counter == 55) {
        set_address(0x00,0x77,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }
    if (data_counter == 56) {
        set_address(0x00,0x78,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }
    if (data_counter == 57) {
        set_address(0x00,0x79,0x00,0x00);
        //for loop below writes history to the sd card
        for(int i=0; i<50; i++) {
            writeByte(current_history[i]);
        }
    }


    data_counter++;
    if (data_counter >57) data_counter=48;
    write_user_counters();

}



void read_user_history()
{
    if (data_cursor == 48) {
        set_address(0x00,0x70,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }
        //pc.printf("after reading from memory 70 %s",temp_string);
    }
    if (data_cursor == 49) {
        int address= 0x71;
        display_string(0,1,"inside slot2",0xFF,0xFF);

        set_address(0x00,address,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }


        //pc.printf("after reading from memory 71 %s",temp_string);
    }

    if (data_cursor == 50) {
        set_address(0x00,0x72,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }

        //pc.printf("after reading from memory 72 %s",temp_string);
    }

    if (data_cursor == 51) {
        set_address(0x00,0x73,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }

        //pc.printf("after reading from memory 73 %s",temp_string);
    }
    if (data_cursor == 52) {
        set_address(0x00,0x74,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }

        //pc.printf("after reading from memory 74%s",temp_string);
    }
    if (data_cursor == 53) {
        set_address(0x00,0x75,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }

        // pc.printf("after reading from memory 75%s",temp_string);
    }
    if (data_cursor == 54) {
        set_address(0x00,0x76,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }

        //pc.printf("after reading from memory 76 %s",temp_string);
    }
    if (data_cursor == 55) {
        set_address(0x00,0x77,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }

        //pc.printf("after reading from memory 77 %s",temp_string);
    }
    if (data_cursor == 56) {
        set_address(0x00,0x78,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }
        // pc.printf("after reading from memory 78%s",temp_string);
    }
    if (data_cursor == 57) {
        set_address(0x00,0x79,0x00,0x00);
        for(int i=0; i<50; i++) {
            while (!lcd.writeable()) {}
            lcd.putc(0x40);

            while (!lcd.writeable()) {}
            lcd.putc(0x72);

            while (!lcd.readable()) {}     //receiving the acknowledgement bit
            temp_string[i]=lcd.getc();
        }

        //pc.printf("after reading from memory 79 %s",temp_string);
    }
}