//Author: Kuldip Maharjan
//Email : kuldipmaharjan@gmail.com
//Anyone can use this code if it helps in their projects or 
//for learning programing in mbed besides for commercial purposes


// This code does some basic stuff with an 24LC256 memory chip

#include "mbed.h"

I2C i2c(p28, p27);  // sda, scl
//DigitalOut wp(p29); // write protect

int main()
{
    //wp = 0; // disable write protect
    printf("Writing bytes 0-16\n");

    char data[3];
    for(int i=0; i<16; i++) {
        data[0] = 0;     // MSB address
        data[1] = i;     // LSB address
        data[2] = i * 3; // data
        if(i2c.write(0xA0, data, 3)) {
            error("Write failed\n");
        }
        while(i2c.write(0xA0, NULL, 0)); // wait to complete
    }

    data[0] = 0;       // MSB address
    data[1] = 255;     // LSB address
    data[2] = 'A';     // data
    if(i2c.write(0xA0, data, 3)) {
        error("Write failed\n");
    }
    while(i2c.write(0xA0, NULL, 0)); // wait to complete

    printf("Setting read pointer to 0\n");

    data[0] = 0;                   // MSB address
    data[1] = 0;                   // LSB address
    if(i2c.write(0xA0, data, 2)) { // send address, but no data
        error("Write failed\n");
    }

    printf("Reading back data bytes 0-16\n");
    
    char response[1];
    for(int i=0; i<256; i++) {
        if(i2c.read(0xA0, response, 1)) {
            error("Read failed\n");
        }
        printf("address %03d = 0x%02X\n", i, response[0]);
    }

}
