#include "mbed.h"

#include "neopixel.h"

#define NRF51_DONGLE

#define LED_COUNT   15

#ifdef NRF51_DONGLE
    #define LED_0 p21
    #define LED_1 p23
    #define LED_2 p22
    
    #define STRIP_0 p15
    #define STRIP_1 p16
    
    #define PULSE_0 p17
    
#elif NRF51_MICROBIT
    #define LED_0 p18
    #define LED_1 p19
#endif

DigitalOut myled_0(LED_0);
DigitalOut myled_1(LED_1);

DigitalOut myledError(LED_2);

neopixel_strip_t m_strip;
uint8_t dig_pin_num = 15;
uint8_t leds_per_strip = 24;
uint8_t result;

uint8_t current = 0;

//clear and remove strip
// neopixel_clear(&m_strip);
// neopixel_destroy(&m_strip);

void renderLine() 
{
    result = neopixel_set_color_and_show(&m_strip, current, 0x22, 0xAA, 0x88);
    
    current = (current + 1) % LED_COUNT;
    
    if (result) {
        myledError = 1;
    }
    else {
        myledError = 0;
    }
}    

int main ()
{
    neopixel_init(&m_strip, STRIP_0, LED_COUNT);
    neopixel_clear(&m_strip);
    
    while (1) {
        myled_0 = 1;
        myled_1 = 0;
        wait (0.2);
        
        myled_0 = 0;
        myled_1 = 1;
        wait (0.2);
        
        renderLine();
    }
}