#include <cmath>
#include "IRSensor.h"
using namespace std;
IRSensor::IRSensor(AnalogIn& distance, DigitalOut& bit0,
                   DigitalOut& bit1, DigitalOut& bit2, int number) :
    distance(distance), bit0(bit0), bit1(bit1), bit2(bit2)
{
    this->number = number;
}
IRSensor::~IRSensor() {}
float IRSensor::read()
{
    switch(number) {
        case 0: 
        bit0 = 0;
        bit1 = 0;
        bit2 = 0;
        break;
        
        case 1: 
        bit0 = 1;
        bit1 = 0;
        bit2 = 0;
        break;
        
        case 2: 
        bit0 = 0;
        bit1 = 1;
        bit2 = 0;
        break;
        
        case 3: 
        bit0 = 1;
        bit1 = 1;
        bit2 = 0;
        break;
        
        case 4: 
        bit0 = 0;
        bit1 = 0;
        bit2 = 1;
        break;
        
        case 5: 
        bit0 = 1;
        bit1 = 0;
        bit2 = 1;
        break;
        
        default:
        bit0 = 0;
        bit1 = 0;
        bit2 = 0;
        break;
        
    }
    
    return -0.58f*sqrt(distance)+0.58f;
}